(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    194073,       5306]*)
(*NotebookOutlinePosition[    194710,       5328]*)
(*  CellTagsIndexPosition[    194666,       5324]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\[Section]4.2 Radioactive Decay", "Section"],

Cell[CellGroupData[{

Cell["Uncertainty near 50000 BP", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = 0.00205226\)], "Input"],

Cell[BoxData[
    \(0.00205226`\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[t_] = Exp[\(-Log[2]\)/5570\ t]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-t\)/5570\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[t_] = Exp[\(-Log[2]\)/5600\ t]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-t\)/5600\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y3[t_] = Exp[\(-Log[2]\)/5630\ t]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-t\)/5630\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p1 = 
      Plot[{ .99  f, f, 1.01  f, y1[t], y2[t], y3[t]}, {t, 49650, 50340}, 
        PlotRange \[Rule] { .9  f, 1.1  f}, Frame \[Rule] True, 
        Axes \[Rule] False, FrameTicks \[Rule] None]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-68.5062 0.00138026 -2.78115 1505.74 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .61803 L
s
0 .61803 m
1 .61803 L
s
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .27812 m
.06244 .27812 L
.10458 .27812 L
.14415 .27812 L
.18221 .27812 L
.22272 .27812 L
.26171 .27812 L
.30316 .27812 L
.34309 .27812 L
.3815 .27812 L
.42237 .27812 L
.46172 .27812 L
.49955 .27812 L
.53984 .27812 L
.57861 .27812 L
.61984 .27812 L
.65954 .27812 L
.69774 .27812 L
.73838 .27812 L
.77751 .27812 L
.81909 .27812 L
.85916 .27812 L
.89771 .27812 L
.93871 .27812 L
.97619 .27812 L
s
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.02381 .33992 m
.06244 .33992 L
.10458 .33992 L
.14415 .33992 L
.18221 .33992 L
.22272 .33992 L
.26171 .33992 L
.30316 .33992 L
.34309 .33992 L
.3815 .33992 L
.42237 .33992 L
.46172 .33992 L
.49955 .33992 L
.53984 .33992 L
.57861 .33992 L
.61984 .33992 L
.65954 .33992 L
.69774 .33992 L
.73838 .33992 L
.77751 .33992 L
.81909 .33992 L
.85916 .33992 L
.89771 .33992 L
.93871 .33992 L
.97619 .33992 L
s
.02381 .34077 m
.06244 .32991 L
.10458 .31811 L
.14415 .30708 L
.18221 .2965 L
.22272 .28528 L
.26171 .27452 L
.30316 .26312 L
.34309 .25218 L
.3815 .24169 L
.42237 .23058 L
.46172 .21991 L
.49955 .20969 L
.53984 .19885 L
.57861 .18845 L
.61984 .17743 L
.65954 .16686 L
.69774 .15672 L
.73838 .14598 L
.77751 .13567 L
.81909 .12475 L
.85916 .11428 L
.89771 .10423 L
.93871 .09358 L
.97619 .08389 L
s
.02381 .44583 m
.06244 .43467 L
.10458 .42254 L
.14415 .41119 L
.18221 .40032 L
.22272 .38878 L
.26171 .37771 L
.30316 .366 L
.34309 .35475 L
.3815 .34396 L
.42237 .33253 L
.46172 .32156 L
.49955 .31105 L
.53984 .2999 L
.57861 .28921 L
.61984 .27788 L
.65954 .267 L
.69774 .25658 L
.73838 .24553 L
.77751 .23493 L
.81909 .2237 L
.85916 .21293 L
.89771 .20259 L
.93871 .19164 L
.97619 .18167 L
s
.02381 .55325 m
.06244 .54178 L
.10458 .52932 L
.14415 .51765 L
.18221 .50647 L
.22272 .49461 L
.26171 .48324 L
.30316 .47119 L
.34309 .45963 L
.3815 .44855 L
.42237 .43679 L
.46172 .42552 L
.49955 .41472 L
.53984 .40325 L
.57861 .39226 L
.61984 .38061 L
.65954 .36943 L
.69774 .35872 L
.73838 .34735 L
.77751 .33645 L
.81909 .32491 L
.85916 .31383 L
.89771 .30321 L
.93871 .29195 L
.97619 .28169 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oool0000P
o`00007ooooo00000ol0003oooooooooo`3ooooooacooooo0Ol00001ooooo`0000?o0000oooooooo
ool0oooooolLooooo`7o00000Oooool00003o`000?oooooooooo0?oooooo7?ooool1o`00007ooooo
00000ol0003oooooooooo`3ooooooacooooo0Ol00001ooooo`0000?o0000ooooooooool0oooooolL
ooooo`7o00000Oooool00003o`000?oooooooooo0?oooooo7?ooool1o`00007ooooo00000ol0003o
ooooooooo`3ooooooacooooo0Ol00001ooooo`0000?o0000ooooooooool0oooooolLooooo`7o0000
0Oooool00003o`000?oooooooooo0?oooooo7?ooool1o`00007ooooo00000ol0003oooooooooo`3o
oooooacooooo0Ol00001ooooo`0000?o0000ooooooooool0oooooolLooooo`7o00000Oooool00003
o`000?oooooooooo0?oooooo7?ooool1o`00007ooooo00000ol0003oooooooooo`3ooooooacooooo
0Ol00001ooooo`0000?o0000ooooooooool0oooooolLooooo`7o00000Oooool00003o`000?oooooo
oooo0?oooooo7?ooool1o`00007ooooo00000ol0003oooooooooo`3ooooooacooooo0Ol00001oooo
o`0000?o0000ooooooooool0oooooolLooooo`7o00000Oooool00003o`000?oooooooooo0?oooooo
7?ooool1o`00007ooooo00000ol0003oooooooooo`3ooooooacooooo0Ol00001ooooo`0000?o0000
ooooooooool0oooooolLooooo`7o00000Oooool00003o`000?oooooooooo0?oooooo7?ooool1o`00
007ooooo00000ol0003oooooooooo`3ooooooacooooo0Ol00001ooooo`0000?o0000ooooooooool0
oooooolLooooo`7o00000Oooool00003o`000?oooooooooo0?oooooo4oooool3o`0000Kooooo0Ol0
0001ooooo`0000?o0000ooooooooool0ooooool>ooooo`Go00002Oooool1o`00007ooooo00000ol0
003oooooooooo`3oooooo`Wooooo1Ol0000>ooooo`7o00000Oooool00003o`000?oooooooooo0?oo
oooo1Oooool4o`0001?ooooo0Ol00001ooooo`0000?o0000ooooooooool0ooooool1ooooo`Co0000
5oooool1o`00007ooooo00000ol0003oooooooooo`3looooo`Co00006oooool1o`00007ooooo0000
0ol0003oooooooooo`3hooooo`Co00007oooool1o`00007ooooo00000ol0003oooooooooo`3eoooo
o`?o00008oooool1o`00007ooooo00000ol0003oooooooooo`3aooooo`Co00009_ooool1o`00007o
oooo00000ol0003oooooooooo`3]ooooo`Co0000:_ooool1o`00007ooooo00000ol0003ooooooooo
o`3Yooooo`Co0000;_ooool1o`00007ooooo00000ol0003oooooooooo`3Uooooo`Co0000<_ooool1
o`00007ooooo00000ol0003oooooooooo`3Qooooo`Co0000=_ooool1o`00007ooooo00000ol0003o
ooooooooo`3Mooooo`Co0000>_ooool1o`00007ooooo00000ol0003oooooooooo`3Iooooo`Co0000
?_ooool1o`00007ooooo00000ol0003oooooooooo`3Eooooo`Co0000@_ooool1o`00007ooooo0000
0ol0003oooooooooo`3Booooo`?o0000A_ooool1o`00007ooooo00000ol0003oooooooooo`3>oooo
o`Co0000BOooool1o`00007ooooo00000ol0003oooooooooo`3:ooooo`Co0000COooool1o`00007o
oooo00000ol0003oooooooooo`37ooooo`?o0000DOooool1o`00007ooooo00000ol0003ooooooooo
o`33ooooo`Co0000E?ooool1o`00007ooooo00000ol0003oooooooooo`2oooooo`Co0000F?ooool1
o`00007ooooo00000ol0003oooooooooo`2looooo`?o0000G?ooool1o`00007ooooo00000ol0003o
ooooooooo`2hooooo`Co0000Goooool1o`00007ooooo00000ol0003oooooooooo`2dooooo`Co0000
Hoooool1o`00007ooooo00000ol0003oooooooooo`2`ooooo`Co0000Ioooool1o`00007ooooo0000
0ol0003oooooooooo`2]ooooo`?o0000Joooool1o`00007ooooo00000ol0003oooooooooo`2Zoooo
o`?o0000K_ooool1o`00007ooooo00000ol0003oooooooooo`2Wooooo`?o0000J?ooool3o`0000Ko
oooo0Ol00001ooooo`0000?o0000ooooooooool0Y?ooool3o`0006Kooooo1Ol00009ooooo`7o0000
0Oooool00003o`000?oooooooooo0:3ooooo1?l0001Uooooo`Co00003_ooool1o`00007ooooo0000
0ol0003oooooooooo`2Jooooo`Ko0000I_ooool3o`0001;ooooo0Ol00001ooooo`0000?o0000oooo
ooooool0U_ooool4o`0006Wooooo0ol0000Eooooo`7o00000Oooool00003o`000?oooooooooo09?o
oooo0ol0001Zooooo`?o00006?ooool1o`00007ooooo00000ol0003oooooooooo`2@ooooo`?o0000
JOooool4o`0001_ooooo0Ol00001ooooo`0000?o0000ooooooooool0SOooool3o`0006Sooooo1?l0
000Oooooo`7o00000Oooool00003o`000?oooooooooo08[ooooo0ol0001Xooooo`?o00008oooool1
o`00007ooooo00000ol0003oooooooooo`26ooooo`Co0000Ioooool4o`0002Kooooo0Ol00001oooo
o`0000?o0000ooooooooool0Poooool3o`0006Oooooo1?l0000Zooooo`7o00000Oooool00003o`00
0?oooooooooo07oooooo1?l0001Vooooo`Co0000;_ooool1o`00007ooooo00000ol0003ooooooooo
o`1kooooo`Co0000I_ooool4o`0003;ooooo0Ol00001ooooo`0000?o0000ooooooooool0N?ooool3
o`0006Kooooo1?l0000fooooo`7o00000Oooool00003o`000?oooooooooo07Cooooo1?l0001Uoooo
o`Co0000>_ooool1o`00007ooooo00000ol0003oooooooooo`1`ooooo`Co0000IOooool4o`0003ko
oooo0Ol00001ooooo`0000?o0000ooooooooool0K?ooool4o`0006Gooooo1?l00012ooooo`7o0000
0Oooool00003o`000?oooooooooo06Sooooo1?l0001Vooooo`?o0000A_ooool1o`00007ooooo0000
0ol0003oooooooooo`1Tooooo`Co0000I_ooool4o`0004Wooooo0Ol00001ooooo`0000?o0000oooo
ooooool0HOooool3o`0006Kooooo1?l0001=ooooo`7o00000Oooool00003o`000?oooooooooo05go
oooo1?l0001Vooooo`?o0000DOooool1o`00007ooooo00000ol0003oooooooooo`1Iooooo`Co0000
I_ooool4o`0005Cooooo0Ol00001ooooo`0000?o0000ooooooooool0E_ooool3o`0006Kooooo1?l0
001Hooooo`7o00000Oooool00003o`000?oooooooooo05;ooooo1?l0001Vooooo`?o0000G?ooool1
o`00007ooooo00000ol0003oooooooooo`1>ooooo`Co0000I_ooool4o`0005oooooo0Ol00001oooo
o`0000?o0000ooooooooool0B_ooool4o`0006Kooooo1?l0001Sooooo`7o00000Oooool00003o`00
0?oooooooooo04Kooooo1?l0001Vooooo`Co0000Ioooool1o`00007ooooo00000ol0003ooooooooo
o`04oooooooo00004_l00006ooooo`7o00000Oooool00003o`000?oooooooooo03oooooo0ol0001V
ooooo`Co0000I_ooool3o`0000Kooooo0Ol00001ooooo`0000?o0000ooooooooool0>oooool4o`00
06Kooooo0ol0001Wooooo`?o00002Oooool1o`00007ooooo00000ol0003oooooooooo`0gooooo`Co
0000I_ooool4o`0006Oooooo0ol0000<ooooo`7o00000Oooool00003o`000?oooooooooo03?ooooo
1?l0001Vooooo`Co0000Ioooool4o`0000oooooo0Ol00001ooooo`0000?o0000ooooooooool0;ooo
ool4o`0006Kooooo1?l0001Wooooo`Co00004oooool1o`00007ooooo00000ol0003oooooooooo`0[
ooooo`Co0000Ioooool3o`0006Oooooo1?l0000Gooooo`7o00000Oooool00003o`000?oooooooooo
02Sooooo0ol0001Xooooo`?o0000I_ooool4o`0001_ooooo0Ol00001ooooo`0000?o0000oooooooo
ool09Oooool3o`0006Sooooo0ol0001Uooooo`Co00007oooool1o`00007ooooo00000ol0003ooooo
ooooo`04oooooooo00004_l00006ooooo`7o00000Oooool00003o`000?oooooooooo01oooooo0ol0
001Xooooo`?o0000IOooool3o`0002Kooooo0Ol00001ooooo`0000?o0000ooooooooool07?ooool3
o`0006Oooooo1?l0001Uooooo`?o0000:Oooool1o`00007ooooo00000ol0003oooooooooo`0Ioooo
o`?o0000Ioooool3o`0006Kooooo0ol0000/ooooo`7o00000Oooool00003o`000?oooooooooo01Go
oooo1?l0001Vooooo`Co0000I_ooool3o`0002oooooo0Ol00001ooooo`0000?o0000ooooooooool0
4Oooool4o`0006Kooooo1?l0001Vooooo`Co0000<_ooool1o`00007ooooo00000ol0003ooooooooo
o`0=ooooo`Co0000Ioooool3o`0006Kooooo1?l0000fooooo`7o00000Oooool00003o`000?oooooo
oooo00Wooooo1?l0001Wooooo`Co0000IOooool4o`0003[ooooo0Ol00001ooooo`0000?o0000oooo
ooooool01_ooool3o`0006Oooooo1?l0001Uooooo`Co0000?_ooool1o`00007ooooo00000ol0003o
ooooooooo`04oooooooo00004_l00006ooooo`7o00000Oooool00003o`000?oooooooooo06Sooooo
1?l0001Vooooo`?o0000A_ooool1o`00007ooooo00000ol0003oooooooooo`1Tooooo`Co0000I_oo
ool4o`0004Wooooo0Ol00001ooooo`0000?o0000ooooooooool0HOooool3o`0006Kooooo1?l0001=
ooooo`7o00000Oooool00003o`000?oooooooooo05gooooo1?l0001Vooooo`?o0000DOooool1o`00
007ooooo00000ol0003oooooooooo`1Iooooo`Co0000I_ooool4o`0005Cooooo0Ol00001ooooo`00
00?o0000ooooooooool0E_ooool3o`0006Kooooo1?l0001Hooooo`7o00000Oooool00003o`000?oo
oooooooo05?ooooo0ol0001Vooooo`?o0000G?ooool1o`00007ooooo00000ol0003oooooooooo`1@
ooooo`?o0000I_ooool3o`0005oooooo0Ol00001ooooo`0000?o0000ooooooooool0COooool3o`00
06Kooooo0ol0001Rooooo`7o00000Oooool00003o`000?oooooooooo04[ooooo0ol0001Vooooo`?o
0000IOooool1o`00007ooooo00000ol0003oooooooooo`16ooooo`Co0000I_ooool3o`0006Sooooo
0Ol00001ooooo`0000?o0000ooooooooool0@_ooool4o`0006Kooooo1?l0001[ooooo`7o00000Ooo
ool00003o`000?oooooooooo03oooooo0ol0001Vooooo`Co0000Koooool1o`00007ooooo00000ol0
003oooooooooo`0kooooo`Co0000I_ooool3o`0007?ooooo0Ol00001ooooo`0000?o0000oooooooo
ool0=oooool4o`0006Kooooo1?l0001fooooo`7o00000Oooool00003o`000?oooooooooo03?ooooo
1?l0001Vooooo`Co0000N_ooool1o`00007ooooo00000ol0003oooooooooo`0_ooooo`Co0000I_oo
ool4o`0007kooooo0Ol00001ooooo`0000?o0000ooooooooool0:oooool4o`0006Kooooo1?l00022
ooooo`7o00000Oooool00003o`000?oooooooooo02Sooooo0ol0001Vooooo`Co0000Q_ooool1o`00
007ooooo00000ol0003oooooooooo`0Uooooo`?o0000I_ooool3o`0008[ooooo0Ol00001ooooo`00
00?o0000ooooooooool08_ooool3o`0006Gooooo1?l0002=ooooo`7o00000Oooool00003o`000?oo
oooooooo01oooooo0ol0001Tooooo`Co0000TOooool1o`00007ooooo00000ol0003oooooooooo`0L
ooooo`?o0000I?ooool3o`0009Gooooo0Ol00001ooooo`0000?o0000ooooooooool06Oooool3o`00
06Cooooo0ol0002Hooooo`7o00000Oooool00003o`000?oooooooooo01Gooooo1?l0001Tooooo`?o
0000Voooool1o`00007ooooo00000ol0003oooooooooo`0Aooooo`Co0000IOooool3o`0009kooooo
0Ol00001ooooo`0000?o0000ooooooooool03Oooool4o`0006Kooooo0ol0002Qooooo`7o00000Ooo
ool00003o`000?oooooooooo00Wooooo1?l0001Wooooo`?o0000Y?ooool1o`00007ooooo00000ol0
003oooooooooo`06ooooo`?o0000Ioooool4o`000:Oooooo0Ol00001ooooo`0000?o0000oooooooo
ool01?ooool2o`0006Kooooo1?l0002[ooooo`7o00000Oooool00003o`000?oooooooooo06Sooooo
1?l0002_ooooo`7o00000Oooool00003o`000?oooooooooo06Cooooo1?l0002cooooo`7o00000Ooo
ool00003o`000?oooooooooo067ooooo0ol0002gooooo`7o00000Oooool00003o`000?oooooooooo
05gooooo1?l0002jooooo`7o00000Oooool00003o`000?oooooooooo05Wooooo1?l0002nooooo`7o
00000Oooool00003o`000?oooooooooo05Kooooo0ol00032ooooo`7o00000Oooool00003o`000?oo
oooooooo05?ooooo0ol00035ooooo`7o00000Oooool00003o`000?oooooooooo053ooooo0ol00038
ooooo`7o00000Oooool00003o`000?oooooooooo04gooooo0ol0003;ooooo`7o00000Oooool00003
o`000?oooooooooo04[ooooo0ol0003>ooooo`7o00000Oooool00003o`000?oooooooooo04Kooooo
1?l0003Aooooo`7o00000Oooool00003o`000?oooooooooo04;ooooo1?l0003Eooooo`7o00000Ooo
ool00003o`000?oooooooooo03oooooo0ol0003Iooooo`7o00000Oooool00003o`000?oooooooooo
03cooooo0ol0003Looooo`7o00000Oooool00003o`000?oooooooooo03Wooooo0ol0003Oooooo`7o
00000Oooool00003o`000?oooooooooo03Kooooo0ol0003Rooooo`7o00000Oooool00003o`000?oo
oooooooo03?ooooo0ol0003Uooooo`7o00000Oooool00003o`000?oooooooooo02oooooo1?l0003X
ooooo`7o00000Oooool00003o`000?oooooooooo02_ooooo1?l0003/ooooo`7o00000Oooool00003
o`000?oooooooooo02Sooooo0ol0003`ooooo`7o00000Oooool00003o`000?oooooooooo02Cooooo
1?l0003cooooo`7o00000Oooool00003o`000?oooooooooo023ooooo1?l0003gooooo`7o00000Ooo
ool00003o`000?oooooooooo01gooooo0ol0003kooooo`7o00000Oooool00003o`000?oooooooooo
01[ooooo0ol0003nooooo`7o00000Oooool00003o`000?oooooooooo01Oooooo0ol0003oooooo`;o
oooo0Ol00001ooooo`0000?o0000ooooooooool05?ooool3o`000?oooooo1Oooool1o`00007ooooo
00000ol0003oooooooooo`0Aooooo`?o0000ooooool8ooooo`7o00000Oooool00003o`000?oooooo
oooo00gooooo1?l0003oooooo`_ooooo0Ol00001ooooo`0000?o0000ooooooooool02Oooool4o`00
0?oooooo3oooool1o`00007ooooo00000ol0003oooooooooo`06ooooo`?o0000oooooolCooooo`7o
00000Oooool00003o`000?oooooooooo00Cooooo0_l0003ooooooaKooooo0Ol00001ooooo`0000?o
0000ooooooooool0oooooolLooooo`7o00000Oooool00003o`000?oooooooooo0?oooooo7?ooool1
o`00007ooooo00000ol0003oooooooooo`3ooooooacooooo0Ol00001ooooo`0000?o0000oooooooo
ool0oooooolLooooo`7o00000Oooool00003o`000?oooooooooo0?oooooo7?ooool1o`00007ooooo
00000ol0003oooooooooo`3ooooooacooooo0Ol00001ooooo`0000?o0000ooooooooool0oooooolL
ooooo`7o00000Oooool00003o`000?oooooooooo0?oooooo7?ooool1o`00007ooooo00000ol0003o
ooooooooo`3ooooooacooooo0Ol00001ooooo`0000?o0000ooooooooool0oooooolLooooo`7o0000
0Oooool00003o`000?oooooooooo0?oooooo7?ooool1o`00007ooooo00000ol0003oooooooooo`3o
oooooacooooo0Ol00001ooooo`0000?o0000ooooooooool0oooooolLooooo`7o00000Oooool00003
o`000?oooooooooo0?oooooo7?ooool1o`00007ooooo00000ol0003oooooooooo`3ooooooacooooo
0Ol00001ooooo`0000?o0000ooooooooool0oooooolLooooo`7o00000Oooool00003o`000?oooooo
oooo0?oooooo7?ooool1o`00007ooooo003oo`00023o00000Oooool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {49631.9, 0.00184703, \
2.53066, 2.31977*^-6}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(pts = 
        Graphics[{PointSize[0.022], Point[{49732, y1[49732]}], 
            Point[{50000, y2[50000]}], 
            Point[{50268, y3[50268]}]}];\)\)], "Input"],

Cell[BoxData[
    \(\(txt = 
        Graphics[{Text["\<h=5570\>", {49850,  .985  f}, {0, 1}], 
            Text["\<h=5600\>", {49850, 1.045  f}, {0, 1}], 
            Text["\<h=5630\>", {49850, 1.08  f}, {0, 1}]}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[p1, pts, txt, 
      FrameTicks \[Rule] {{49732, 50000, 50268}, None, 
          None, {{0.985  f, "\<0.99f\>"}, {f, "\<1.00f\>"}, {1.015  
                f, "\<1.01f\>"}}}, 
      FrameLabel \[Rule] {"\<Years BP\>", "\<Amount\n Present\>"}, 
      RotateLabel \[Rule] False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-68.5062 0.00138026 -2.78115 1505.74 [
[.13699 -0.0125 -15 -9 ]
[.13699 -0.0125 15 0 ]
[.5069 -0.0125 -15 -9 ]
[.5069 -0.0125 15 0 ]
[.87681 -0.0125 -15 -9 ]
[.87681 -0.0125 15 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -26 -21 ]
[.5 -0.0125 26 -9 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -52 -12.25 ]
[-0.01875 .30902 0 12.25 ]
[ 0 .61803 .125 0 ]
[1.0125 .26266 0 -6 ]
[1.0125 .26266 34 6 ]
[1.0125 .30902 0 -6 ]
[1.0125 .30902 34 6 ]
[1.0125 .35537 0 -6 ]
[1.0125 .35537 34 6 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.13699 0 m
.13699 .00625 L
s
[(49732)] .13699 -0.0125 0 1 Mshowa
.5069 0 m
.5069 .00625 L
s
[(50000)] .5069 -0.0125 0 1 Mshowa
.87681 0 m
.87681 .00625 L
s
[(50268)] .87681 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
gsave
.5 -0.0125 -87 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Years) show
99.000 13.000 moveto
(BP) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -113 -16.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 32.5 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Amount) show
69.000 25.500 moveto
(Present) show
111.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .61803 m
1 .61803 L
s
.99375 .26266 m
1 .26266 L
s
gsave
1.0125 .26266 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.99) show
87.000 13.000 moveto
(f) show
93.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .30902 m
1 .30902 L
s
gsave
1.0125 .30902 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.00) show
87.000 13.000 moveto
(f) show
93.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .35537 m
1 .35537 L
s
gsave
1.0125 .35537 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.01) show
87.000 13.000 moveto
(f) show
93.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .27812 m
.06244 .27812 L
.10458 .27812 L
.14415 .27812 L
.18221 .27812 L
.22272 .27812 L
.26171 .27812 L
.30316 .27812 L
.34309 .27812 L
.3815 .27812 L
.42237 .27812 L
.46172 .27812 L
.49955 .27812 L
.53984 .27812 L
.57861 .27812 L
.61984 .27812 L
.65954 .27812 L
.69774 .27812 L
.73838 .27812 L
.77751 .27812 L
.81909 .27812 L
.85916 .27812 L
.89771 .27812 L
.93871 .27812 L
.97619 .27812 L
s
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.02381 .33992 m
.06244 .33992 L
.10458 .33992 L
.14415 .33992 L
.18221 .33992 L
.22272 .33992 L
.26171 .33992 L
.30316 .33992 L
.34309 .33992 L
.3815 .33992 L
.42237 .33992 L
.46172 .33992 L
.49955 .33992 L
.53984 .33992 L
.57861 .33992 L
.61984 .33992 L
.65954 .33992 L
.69774 .33992 L
.73838 .33992 L
.77751 .33992 L
.81909 .33992 L
.85916 .33992 L
.89771 .33992 L
.93871 .33992 L
.97619 .33992 L
s
.02381 .34077 m
.06244 .32991 L
.10458 .31811 L
.14415 .30708 L
.18221 .2965 L
.22272 .28528 L
.26171 .27452 L
.30316 .26312 L
.34309 .25218 L
.3815 .24169 L
.42237 .23058 L
.46172 .21991 L
.49955 .20969 L
.53984 .19885 L
.57861 .18845 L
.61984 .17743 L
.65954 .16686 L
.69774 .15672 L
.73838 .14598 L
.77751 .13567 L
.81909 .12475 L
.85916 .11428 L
.89771 .10423 L
.93871 .09358 L
.97619 .08389 L
s
.02381 .44583 m
.06244 .43467 L
.10458 .42254 L
.14415 .41119 L
.18221 .40032 L
.22272 .38878 L
.26171 .37771 L
.30316 .366 L
.34309 .35475 L
.3815 .34396 L
.42237 .33253 L
.46172 .32156 L
.49955 .31105 L
.53984 .2999 L
.57861 .28921 L
.61984 .27788 L
.65954 .267 L
.69774 .25658 L
.73838 .24553 L
.77751 .23493 L
.81909 .2237 L
.85916 .21293 L
.89771 .20259 L
.93871 .19164 L
.97619 .18167 L
s
.02381 .55325 m
.06244 .54178 L
.10458 .52932 L
.14415 .51765 L
.18221 .50647 L
.22272 .49461 L
.26171 .48324 L
.30316 .47119 L
.34309 .45963 L
.3815 .44855 L
.42237 .43679 L
.46172 .42552 L
.49955 .41472 L
.53984 .40325 L
.57861 .39226 L
.61984 .38061 L
.65954 .36943 L
.69774 .35872 L
.73838 .34735 L
.77751 .33645 L
.81909 .32491 L
.85916 .31383 L
.89771 .30321 L
.93871 .29195 L
.97619 .28169 L
s
.022 w
.13699 .30907 Mdot
.5069 .30902 Mdot
.87681 .30896 Mdot
gsave
.29986 .26266 -81 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
69.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5570) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.29986 .44807 -81 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
69.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5600) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.29986 .55623 -81 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
69.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5630) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{332.188, 205.312},
  ImageMargins->{{42, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005<0000cB000`400?l00000o`00003ooooooom=
ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=
ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=
ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=
ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=
ooooo`00V?ooool3o`0000?ooooo0ol00003ooooo`Co000000Coooooo`000?l0003o00000oooool4
o`0000Sooooo1?l00002ooooo`?o0000R?ooool009Wooooo00Go0000ooooooooooooooooo`000005
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0Qoooool009Wooooo00Co
0000oooooooooooooooo1Ol00002ooooo`?o00000oooool00ol0003oooooooooo`03ooooo`?o0000
2Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo08Oooooo002Iooooo`05o`00
0?ooooooooooooooool000000oooool00ol0003oooooo`000002ooooo`04o`000?oooooooooooooo
o`;o00000oooool00ol0003oooooooooo`0:ooooo`?o00000oooool3o`0008Oooooo002Hooooo`03
o`000?oooooo000000?ooooo0ol00003ooooo`;o00000oooool2o`000003ooooool0003o000000;o
oooo1?l00008ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000Q_ooool0
09Sooooo00?o0000ooooool000008Oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0008Kooooo002Gooooo`;o000000?oooooo`000?l000007oooool4o`0000;ooooo1?l00027
ooooo`00oooooom=ooooo`00oooooom=ooooo`00C?ooool3o`0000;ooooo0_l00005ooooo`03o`00
0?oooooooooo00;ooooo0ol00002ooooo`Go0000>oooool3o`0000Cooooo0_l00004ooooo`;o0000
1?ooool2o`0000Cooooo0_l0000mooooo`?o00001?ooool2o`0000;ooooo1Ol00002ooooo`?o0000
0oooool3o`0003Oooooo001=ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_oo
ool01Ol0003ooooooooooooooooo000000?ooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`0hooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool0000kooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002
ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooo`000003ooooo`03o`00
0?oooooooooo03Cooooo001:ooooo`Go00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00Cooooo00Go0000ooooooooooooooooo`000010ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000;ooooo00?o0000ooooooooool0?Oooool01?l0003oooooooooool00002ooooo`05o`00
0?ooooooooooooooool000000oooool01ol0003ooooooooooooooooo0000ooooool000000oooool0
0ol0003oooooooooo`0dooooo`00B_ooool01?l0003oooooooooool00003ooooo`Co00001?ooool0
0ol0003oooooooooo`02ooooo`;o00001Oooool00ol0003oooooooooo`0mooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0?Oooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?l00003ooooo`?o0000=oooool0
04_ooooo00?o0000ooooool000000_ooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000
ooooooooool00oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo03Sooooo1?l00003
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool00002ooooo`04o`000?ooooooooooo`0003_ooooo1?l00003ooooo`06o`000?oooooooooo
o`000?oooooo00000oooool00ol0003oooooo`000005ooooo`05o`000?ooooooooooooooool00000
=_ooool004cooooo0_l00002ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`03
o`000?oooooo000000?ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`0hooooo`03
o`000?oooooooooo00Cooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000>oooool00ol0003ooooo
ooooo`04ooooo`06o`000?ooooooooooo`000?oooooo00000oooool01?l0003oooooooooool00004
ooooo`05o`000?ooooooooooooooool00000=_ooool004gooooo00Co0000oooooooooooooooo0ol0
0002ooooo`Go00000_ooool3o`0000?ooooo0ol0000kooooo`Go00000oooool2o`0000Cooooo0_l0
0004ooooo`;o00001?ooool2o`0003cooooo1Ol00003ooooo`;o00000oooool3o`0000Cooooo0_l0
0003ooooo`?o0000=oooool00?ooooooCOooool00?ooooooCOooool00?ooooooCOooool00?oooooo
COooool003Soooookol0000Uooooo`00>?ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooo
oooo05Cooooo00?o0000ooooooooool0EOooool00ol0003oooooooooo`0Kooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo0>_ooooo00?o0000ooooooooool08oooool003So
oooo00?o0000ooooooooool0joooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooo
ooooo`3[ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>_ooooo00?o
0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0joooool00ol0003oooooooooo`0S
ooooo`00>?ooool00ol0003oooooooooo`3[ooooo`03o`000?oooooooooo02?ooooo000hooooo`03
o`000?oooooooooo0>_ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0
joooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3[ooooo`03o`000?oo
oooooooo02?ooooo000hooooo`03o`000?oooooooooo0>_ooooo00?o0000ooooooooool08oooool0
03Sooooo00?o0000ooooooooool0joooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003o
ooooooooo`3[ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>_ooooo
00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0joooool00ol0003ooooooooo
o`0Sooooo`00>?ooool00ol0003oooooooooo`3[ooooo`03o`000?oooooooooo02?ooooo000hoooo
o`03o`000?oooooooooo0>_ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooooooo
ool0joooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3[ooooo`03o`00
0?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>?ooooo0ol00005ooooo`03o`000?oo
oooooooo02?ooooo000hooooo`03o`000?oooooooooo0=kooooo1Ol00008ooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo0=[ooooo1?l0000=ooooo`03o`000?oooooooooo
02?ooooo000hooooo`03o`000?oooooooooo0=Oooooo0ol0000Aooooo`03o`000?oooooooooo02?o
oooo000hooooo`03o`000?oooooooooo0=Cooooo0ol0000Dooooo`03o`000?oooooooooo02?ooooo
000hooooo`03o`000?oooooooooo0=3ooooo1?l0000Gooooo`03o`000?oooooooooo02?ooooo000h
ooooo`03o`000?oooooooooo0<_ooooo1Ol0000Kooooo`03o`000?oooooooooo02?ooooo000hoooo
o`03o`000?oooooooooo0<Sooooo0ol0000Pooooo`03o`000?oooooooooo02?ooooo000hooooo`03
o`000?oooooooooo0<Gooooo0ol0000Sooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`00
0?oooooooooo0<;ooooo0ol0000Vooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oo
oooooooo0;kooooo1?l0000Yooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooo
oooo0;Wooooo1Ol0000]ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo
0;Gooooo1?l0000booooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0;;o
oooo0ol0000fooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0:oooooo
0ol0000iooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0:_ooooo1?l0
000looooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0:Kooooo1Ol00010
ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0:;ooooo1?l00015oooo
o`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo09oooooo0ol00019ooooo`03
o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo09cooooo0ol0001<ooooo`03o`00
0?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo09Sooooo1?l0001?ooooo`03o`000?oo
oooooooo02?ooooo000hooooo`03o`000?oooooooooo09?ooooo1Ol0001Cooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo08oooooo1?l0001Hooooo`03o`000?oooooooooo
02?ooooo000hooooo`03o`000?oooooooooo08cooooo0ol0001Dooooo`?o00001Oooool00ol0003o
ooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`29ooooo`?o0000D_ooool5o`0000Sooooo
00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0QOooool4o`00057ooooo1?l0
000=ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo083ooooo1Ol0001B
ooooo`?o00004Oooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`1loooo
o`Co0000E?ooool3o`0001Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooooooo
ool0NOooool3o`0005Cooooo1?l0000Gooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`00
0?oooooooooo07Kooooo0ol0001Booooo`Go00006oooool00ol0003oooooooooo`0Sooooo`00>?oo
ool00ol0003oooooooooo`1booooo`Co0000D_ooool3o`00023ooooo00?o0000ooooooooool08ooo
ool003Sooooo00?o0000ooooooooool0KOooool5o`0005?ooooo0ol0000Sooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo06Wooooo1?l0001Eooooo`?o00009_ooool00ol0
003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`1Vooooo`?o0000EOooool4o`0002Wo
oooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0<_ooool6o`000003oooo
ool0003o000000;o00000_ooool3o`0000?ooooo0ol00004ooooo`03o`000?oooooooooo00?ooooo
0_l0000?ooooo`?o0000EOooool3o`0002gooooo00?o0000ooooooooool08oooool003Sooooo00?o
0000ooooooooool0<oooool01?l0003oooooooooool00007ooooo`07o`000?ooooooooooooooool0
003oooooo`000003ooooo`05o`000?ooooooooooooooool000001?ooool01?l0003oooooooooool0
000:ooooo`Co0000EOooool3o`00033ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000
ooooooooool0<oooool01?l0003oooooooooool00002ooooo`Co00001Oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`00
0?oooooooooo00?ooooo1Ol0001Eooooo`Co0000<oooool00ol0003oooooooooo`0Sooooo`00>?oo
ool00ol0003oooooooooo`0cooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003o
ooooooooo`03o`0005Gooooo1Ol0000gooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`00
0?oooooooooo03?ooooo0ol00008ooooo`Co00000_ooool4o`0000Kooooo00Co0000oooooooooooo
00000_ooool3o`0005Cooooo1?l0000looooo`03o`000?oooooooooo02?ooooo000hooooo`03o`00
0?oooooooooo03?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`Co0000Doooool3o`00043o
oooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0<_ooool2o`0000[ooooo
1Ol000000ooooooo0000o`000003o`000003ooooool0003o000000Go000000?oooooo`000?l00000
DOooool3o`0004?ooooo00?o0000ooooooooool01?ooool2o`0000Cooooo00?o0000ooooooooool0
0_ooool2o`0000Cooooo0_l00003ooooo`Go00001?ooool003Sooooo00?o0000ooooooooool0B?oo
ool5o`0005Cooooo1?l00016ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo0000
2_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
1?ooool003Sooooo00?o0000ooooooooool0@oooool5o`0005Cooooo1Ol00018ooooo`?o00001Ooo
ool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooo
ooooo`000006ooooo`00>?ooool00ol0003oooooooooo`10ooooo`?o0000EOooool4o`0004oooooo
00?o0000ooooooooool00oooool01?l0003oooooooooool00008ooooo`Co00000_ooool4o`0000?o
oooo00?o0000ooooooooool01?ooool003Sooooo00?o0000ooooooooool0?Oooool3o`0005Gooooo
0ol0001Cooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00001oooool01ol0003o
oooooooooooooooo0000ooooool000000oooool00ol0003oooooooooo`04o`0000Cooooo0008oooo
o`?o00000oooool3o`0000Cooooo0ol00002ooooo`Co00000oooool3o`0000;ooooo0ol000000ooo
oooo0000o`000002ooooo`;o00002?ooool00ol0003oooooooooo`0jooooo`?o0000EOooool3o`00
05Kooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00007ooooo`07o`000?oooooo
ooooooooool0003oooooo`000003ooooo`05o`000?ooooooooooooooool000001_ooool000Wooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooool000001_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00Oooooo00?o0000ooooooooool00ooooooSo`0000Gooooo00?o0000ooooooooool01?ooool2o`00
00Wooooo0ol00003ooooo`?o00001Oooool2o`0000Cooooo0009ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool00_ooool5o`0000;ooooo0ol00002ooooo`Go00000_ooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0=?ooool3o`00
05Gooooo0ol0001Dooooo`?o00001Oooool00ol0003oooooooooo`0Sooooo`002Oooool3o`0000?o
oooo0_l00003ooooo`07o`000?ooooooooooooooool0003oooooo`000005ooooo`05o`000?oooooo
ooooooooool000000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool0<?ooool4o`0005Gooooo0ol0001Booooo`Go00002?ooool00ol0003ooooo
ooooo`0Sooooo`002Oooool01Ol0003oooooooooool0003ooooo00;o000000?oooooo`000?l00000
0_ooool3o`0000?ooooo1?l00002ooooo`?o00000_ooool4o`0000;ooooo1?l00008ooooo`03o`00
0?oooooooooo02_ooooo1Ol0001Eooooo`Co0000DOooool4o`0000gooooo00?o0000ooooooooool0
8oooool000Wooooo00Co0000oooooooooooo00008?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo02Oooooo1?l0001Eooooo`Go0000D_ooool3o`00017ooooo00?o0000ooooooooool0
8oooool000Sooooo1?l0000Qooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool07?oo
ool3o`0000Gooooo0ol0001=ooooo`?o00001Oooool4o`0004cooooo0ol00005ooooo`?o00005?oo
ool00ol0003oooooooooo`03ooooo`?o00001?ooool00ol0003oooooooooo`03ooooo`;o00001?oo
ool2o`0000;ooooo1Ol00004ooooo`00>?ooool00ol0003oooooooooo`0Kooooo`Go000000Cooooo
o`000?l0003o0000Coooool5o`000004ooooool0003o0000o`0004oooooo2Ol0000Gooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool02?ooool01?l0003oooooooooool00002ooooo`04
o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01?ooool003Sooooo00?o0000oooooooo
ool00ooooooSo`0000?ooooo0ol00006ooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Cooooo000hoooo
o`03o`000?oooooooooo01Sooooo2?l0001Booooo`Ko0000D?ooool8o`0001_ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00000oooool00ol0003oooooooooo`04ooooo`00>?ooool00ol0003oooooooooo`0D
ooooo`Co00001?ooool3o`0004kooooo1Ol00002ooooo`?o0000C_ooool3o`0000Cooooo0ol0000L
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0000;ooooo1?l00004ooooo`00>?ooool00ol0003ooooooooo
o`0Aooooo`?o0000EOooool4o`0005Gooooo0ol0000Vooooo`03o`000?oooooooooo00?ooooo0_l0
000:ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003o
ooooooooo`04ooooo`00>?ooool00ol0003oooooooooo`0>ooooo`?o0000EOooool3o`0005Gooooo
1?l0000Yooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02Oooool2o`0000Cooooo
0_l00005ooooo`;o00001?ooool000;ooooo0_l000000ooooooo0000o`000002o`000004ooooool0
003oooooo`0000;ooooo0ol00004ooooo`;o000000?oooooo`000?l000000_l000000ooooooo0000
o`000002ooooo`;o00005?ooool00ol0003oooooooooo`0;ooooo`?o0000EOooool3o`0005Gooooo
0ol0000]ooooo`03o`000?oooooooooo02?ooooo0002ooooo`0=o`000?ooooooooooooooool0003o
ooooo`000?oooooo0000ooooool0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo
00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool02?ooool3o`0005Gooooo0ol0001Eooooo`?o0000<?ooool00ol0
003oooooooooo`0Sooooo`000_ooool5o`000008ooooool0003oooooo`000?oooooo0000ooooool0
0003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool0000Fooooo`03o`000?oooooooooo00Gooooo0ol0001Eooooo`?o0000E?ooool4o`00
03?ooooo00?o0000ooooooooool08oooool000?ooooo00?o0000ooooool000000_ooool01ol0003o
ooooo`000?oooooo0000ooooool000000oooool01?l0003oooooooooool00002ooooo`04o`000?oo
ooooooooo`0000;ooooo00Co0000oooooooooooo00005_ooool00ol0003oooooooooo`03ooooon?o
00001Oooool00ol0003oooooooooo`0Sooooo`000oooool00ol0003oooooo`000002ooooo`;o0000
00?oooooo`000?ooool00_ooool3o`0000;ooooo0_l000001?oooooo0000o`000?ooool4o`0000;o
oooo1?l0000Dooooo`03o`000?oooooooooo05Kooooo1?l0001Aooooo`Co0000??ooool00ol0003o
ooooooooo`03ooooo`?o00001?ooool00ol0003oooooooooo`03ooooo`;o00000oooool3o`0000;o
oooo1Ol00004ooooo`001?ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool0DOooool5o`0005;ooooo0ol00010ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool02?ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool01?ooool000?ooooo0_l0000Looooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool0COooool4o`0005Cooooo0ol00011ooooo`?o00001_ooool00ol0003ooooo
ooooo`08ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`04ooooo`00>?ooool00ol0003oooooooooo`1:ooooo`?o0000EOooool3o`0004Kooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000?o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04ooooo`00>?ooool00ol0003ooooo
ooooo`17ooooo`?o0000EOooool3o`0004Wooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`08ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_ooool4o`0000Co
oooo000hooooo`03o`000?oooooooooo04?ooooo1?l0001Eooooo`?o0000C?ooool00ol0003ooooo
ooooo`03ooooo`;o00002_ooool01?l0003oooooooooool00002ooooo`;o00001Oooool00ol0003o
ooooooooo`04ooooo`00>?ooool00ol0003oooooooooo`10ooooo`?o0000EOooool4o`0004oooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`;o00001?ooool00ol0003ooooo
ooooo`04ooooo`;o00001?ooool003Sooooo00?o0000ooooooooool0?Oooool3o`0005?ooooo1Ol0
001Cooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo03Wooooo1?l0001B
ooooo`Co0000F?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0doooo
o`Go0000Doooool3o`0005cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooooooo
ool0<?ooool4o`0005Gooooo0ol0001Oooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`00
0?oooooooooo02gooooo0ol0001Eooooo`Co0000H_ooool00ol0003oooooooooo`0Sooooo`00>?oo
ool00ol0003oooooooooo`0Zooooo`?o0000EOooool3o`0006Kooooo00?o0000ooooooooool08ooo
ool003Sooooo00?o0000ooooooooool09oooool3o`0005Gooooo0ol0001Yooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo02Cooooo0ol0001Dooooo`Co0000K?ooool00ol0
003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Qooooo`?o0000D_ooool5o`00073o
oooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool07Oooool4o`00017ooooo
1_l000000ooooooo0000o`000002o`0000;ooooo0ol00003ooooo`?o00001?ooool2o`0000Cooooo
0_l0000Oooooo`?o0000MOooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooooooo
o`0Hooooo`Go00005_ooool01?l0003oooooooooool00007ooooo`07o`000?ooooooooooooooool0
003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooooooo`0Iooooo`?o0000N?ooool00ol0003oooooooooo`0Sooooo`00>?ooool0
0ol0003oooooooooo`0Dooooo`Co00006oooool01?l0003oooooooooool00002ooooo`Co00001Ooo
ool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`0Fooooo`?o0000Noooool00ol0003oooooooooo`0Sooooo`00
>?ooool00ol0003oooooooooo`0Aooooo`?o00007oooool01?l0003oooooooooool0000;ooooo`03
o`000?oooooo000000?o00000oooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`0001Cooooo1?l0001nooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo
00kooooo0ol0000Rooooo`?o00002?ooool4o`0000;ooooo00?o0000ooooooooool01?ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`00017ooooo0ol00022ooooo`03o`000?oo
oooooooo02?ooooo000hooooo`03o`000?oooooooooo00_ooooo0ol0000Uooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00003_ooool3o`0008Gooooo00?o0000ooooooooool0
8oooool003Sooooo00?o0000ooooooooool02?ooool3o`0002Oooooo0_l0000:ooooo`Go00000ooo
ool2o`0000Cooooo0_l00004ooooo`;o00003?ooool3o`0008Sooooo00?o0000ooooooooool08ooo
ool003Sooooo00?o0000ooooooooool01Oooool3o`0005Gooooo0ol0002;ooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo00?ooooo0_l0001Eooooo`?o0000S_ooool00ol0
003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`1Fooooo`Co0000TOooool00ol0003o
ooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`1Aooooo`Go0000UOooool00ol0003ooooo
ooooo`0Sooooo`00>?ooool00ol0003oooooooooo`1=ooooo`Co0000V_ooool00ol0003ooooooooo
o`0Sooooo`00>?ooool00ol0003oooooooooo`1:ooooo`?o0000W_ooool00ol0003oooooooooo`0S
ooooo`00>?ooool00ol0003oooooooooo`17ooooo`?o0000XOooool00ol0003oooooooooo`0Soooo
o`00>?ooool00ol0003oooooooooo`13ooooo`Co0000Y?ooool00ol0003oooooooooo`0Sooooo`00
>?ooool00ol0003oooooooooo`10ooooo`?o0000Z?ooool00ol0003oooooooooo`0Sooooo`00>?oo
ool00ol0003oooooooooo`0mooooo`?o0000Zoooool00ol0003oooooooooo`0Sooooo`00>?ooool0
0ol0003oooooooooo`0iooooo`Co0000[_ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0
003oooooooooo`0dooooo`Go0000/_ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003o
ooooooooo`0`ooooo`Co0000]oooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooo
ooooo`0]ooooo`?o0000^oooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooooooo
o`0Zooooo`?o0000__ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0W
ooooo`?o0000`Oooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Toooo
o`?o0000a?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Qooooo`?o
0000aoooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Nooooo`?o0000
b_ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Kooooo`?o00005?oo
ool6o`000003ooooool0003o000000;o00000_ooool3o`0000?ooooo0ol00003ooooo`?o00001?oo
ool2o`0009Oooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool06?ooool3
o`0001Sooooo00Co0000oooooooooooo00001oooool01ol0003ooooooooooooooooo0000ooooool0
00000oooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool0U?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Dooooo`Co
00006oooool01?l0003oooooooooool00002ooooo`Co00001Oooool00ol0003oooooo`000003oooo
o`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`2D
ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo017ooooo0ol0000Ooooo
o`04o`000?ooooooooooo`0000_ooooo00?o0000ooooool000000ol00004ooooo`;o00000oooool0
1?l0003oooooooooool0002Fooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooo
oooo00kooooo0ol0000Rooooo`?o00002?ooool4o`0000;ooooo00?o0000ooooooooool01oooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo09Cooooo00?o0000ooooooooool08ooo
ool003Sooooo00?o0000ooooooooool02_ooool4o`0002Gooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`04o`000?ooooooooooo`0009Kooooo00?o0000ooooooooool08oooool003Sooooo00?o
0000ooooooooool01Oooool5o`0002Sooooo0_l0000:ooooo`Go00000oooool2o`0000?ooooo0ol0
0004ooooo`;o0000Uoooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`03
ooooo`;o0000i_ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3[oooo
o`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>_ooooo00?o0000oooooooo
ool08oooool003Sooooo00?o0000ooooooooool0joooool00ol0003oooooooooo`0Sooooo`00>?oo
ool00ol0003oooooooooo`3[ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooo
oooo0>_ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0joooool00ol0
003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3[ooooo`03o`000?oooooooooo02?o
oooo000hooooo`03o`000?oooooooooo0>_ooooo00?o0000ooooooooool08oooool003Sooooo00?o
0000ooooooooool0joooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3[
ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>_ooooo00?o0000oooo
ooooool08oooool003Sooooo00?o0000ooooooooool0joooool00ol0003oooooooooo`0Sooooo`00
>?ooool00ol0003oooooooooo`3[ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oo
oooooooo0>_ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0joooool0
0ol0003oooooooooo`0Sooooo`00>?ooooo_o`0002Gooooo003oooooodgooooo003oooooodgooooo
003oooooodgooooo003oooooodgooooo003oooooodgooooo003oooooodgooooo003oooooodgooooo
003oooooodgooooo003oooooodgooooo003oooooodgooooo003oooooodgooooo003oooooodgooooo
003oooooodgooooo003oooooodgooooo003oooooodgooooo003oooooodgooooo0000\
\>"],
  ImageRangeCache->{{{0, 331.188}, {204.312, 0}} -> {49460.8, 0.00173342, \
3.04726, 2.79332*^-6}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Uncertainty near 1950 BP", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = 0.7856\)], "Input"],

Cell[BoxData[
    \(0.7856`\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[t_] = Exp[\(-Log[2]\)/5570\ t]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-t\)/5570\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[t_] = Exp[\(-Log[2]\)/5600\ t]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-t\)/5600\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y3[t_] = Exp[\(-Log[2]\)/5630\ t]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-t\)/5630\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p1 = 
      Plot[{ .99  f, f, 1.01  f, y1[t], y2[t], y3[t]}, {t, 1830, 2040}, 
        PlotRange \[Rule] { .98  f, 1.02  f}, Frame \[Rule] True, 
        Axes \[Rule] False, FrameLabel \[Rule] None]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-8.27551 0.00453515 -15.1418 19.6676 [
[.11451 -0.0125 -12 -9 ]
[.11451 -0.0125 12 0 ]
[.34127 -0.0125 -12 -9 ]
[.34127 -0.0125 12 0 ]
[.56803 -0.0125 -12 -9 ]
[.56803 -0.0125 12 0 ]
[.79478 -0.0125 -12 -9 ]
[.79478 -0.0125 12 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .0022 -24 -4.5 ]
[-0.0125 .0022 0 4.5 ]
[-0.0125 .10054 -30 -4.5 ]
[-0.0125 .10054 0 4.5 ]
[-0.0125 .19888 -24 -4.5 ]
[-0.0125 .19888 0 4.5 ]
[-0.0125 .29722 -30 -4.5 ]
[-0.0125 .29722 0 4.5 ]
[-0.0125 .39555 -24 -4.5 ]
[-0.0125 .39555 0 4.5 ]
[-0.0125 .49389 -30 -4.5 ]
[-0.0125 .49389 0 4.5 ]
[-0.0125 .59223 -18 -4.5 ]
[-0.0125 .59223 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11451 0 m
.11451 .00625 L
s
[(1850)] .11451 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(1900)] .34127 -0.0125 0 1 Mshowa
.56803 0 m
.56803 .00625 L
s
[(1950)] .56803 -0.0125 0 1 Mshowa
.79478 0 m
.79478 .00625 L
s
[(2000)] .79478 -0.0125 0 1 Mshowa
.125 Mabswid
.15986 0 m
.15986 .00375 L
s
.20522 0 m
.20522 .00375 L
s
.25057 0 m
.25057 .00375 L
s
.29592 0 m
.29592 .00375 L
s
.38662 0 m
.38662 .00375 L
s
.43197 0 m
.43197 .00375 L
s
.47732 0 m
.47732 .00375 L
s
.52268 0 m
.52268 .00375 L
s
.61338 0 m
.61338 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.70408 0 m
.70408 .00375 L
s
.74943 0 m
.74943 .00375 L
s
.06916 0 m
.06916 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.84014 0 m
.84014 .00375 L
s
.88549 0 m
.88549 .00375 L
s
.93084 0 m
.93084 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .0022 m
.00625 .0022 L
s
[(0.77)] -0.0125 .0022 1 0 Mshowa
0 .10054 m
.00625 .10054 L
s
[(0.775)] -0.0125 .10054 1 0 Mshowa
0 .19888 m
.00625 .19888 L
s
[(0.78)] -0.0125 .19888 1 0 Mshowa
0 .29722 m
.00625 .29722 L
s
[(0.785)] -0.0125 .29722 1 0 Mshowa
0 .39555 m
.00625 .39555 L
s
[(0.79)] -0.0125 .39555 1 0 Mshowa
0 .49389 m
.00625 .49389 L
s
[(0.795)] -0.0125 .49389 1 0 Mshowa
0 .59223 m
.00625 .59223 L
s
[(0.8)] -0.0125 .59223 1 0 Mshowa
.125 Mabswid
0 .02187 m
.00375 .02187 L
s
0 .04154 m
.00375 .04154 L
s
0 .06121 m
.00375 .06121 L
s
0 .08087 m
.00375 .08087 L
s
0 .12021 m
.00375 .12021 L
s
0 .13988 m
.00375 .13988 L
s
0 .15954 m
.00375 .15954 L
s
0 .17921 m
.00375 .17921 L
s
0 .21855 m
.00375 .21855 L
s
0 .23821 m
.00375 .23821 L
s
0 .25788 m
.00375 .25788 L
s
0 .27755 m
.00375 .27755 L
s
0 .31688 m
.00375 .31688 L
s
0 .33655 m
.00375 .33655 L
s
0 .35622 m
.00375 .35622 L
s
0 .37589 m
.00375 .37589 L
s
0 .41522 m
.00375 .41522 L
s
0 .43489 m
.00375 .43489 L
s
0 .45456 m
.00375 .45456 L
s
0 .47422 m
.00375 .47422 L
s
0 .51356 m
.00375 .51356 L
s
0 .53323 m
.00375 .53323 L
s
0 .55289 m
.00375 .55289 L
s
0 .57256 m
.00375 .57256 L
s
0 .6119 m
.00375 .6119 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.11451 .61178 m
.11451 .61803 L
s
.34127 .61178 m
.34127 .61803 L
s
.56803 .61178 m
.56803 .61803 L
s
.79478 .61178 m
.79478 .61803 L
s
.125 Mabswid
.15986 .61428 m
.15986 .61803 L
s
.20522 .61428 m
.20522 .61803 L
s
.25057 .61428 m
.25057 .61803 L
s
.29592 .61428 m
.29592 .61803 L
s
.38662 .61428 m
.38662 .61803 L
s
.43197 .61428 m
.43197 .61803 L
s
.47732 .61428 m
.47732 .61803 L
s
.52268 .61428 m
.52268 .61803 L
s
.61338 .61428 m
.61338 .61803 L
s
.65873 .61428 m
.65873 .61803 L
s
.70408 .61428 m
.70408 .61803 L
s
.74943 .61428 m
.74943 .61803 L
s
.06916 .61428 m
.06916 .61803 L
s
.02381 .61428 m
.02381 .61803 L
s
.84014 .61428 m
.84014 .61803 L
s
.88549 .61428 m
.88549 .61803 L
s
.93084 .61428 m
.93084 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .0022 m
1 .0022 L
s
.99375 .10054 m
1 .10054 L
s
.99375 .19888 m
1 .19888 L
s
.99375 .29722 m
1 .29722 L
s
.99375 .39555 m
1 .39555 L
s
.99375 .49389 m
1 .49389 L
s
.99375 .59223 m
1 .59223 L
s
.125 Mabswid
.99625 .02187 m
1 .02187 L
s
.99625 .04154 m
1 .04154 L
s
.99625 .06121 m
1 .06121 L
s
.99625 .08087 m
1 .08087 L
s
.99625 .12021 m
1 .12021 L
s
.99625 .13988 m
1 .13988 L
s
.99625 .15954 m
1 .15954 L
s
.99625 .17921 m
1 .17921 L
s
.99625 .21855 m
1 .21855 L
s
.99625 .23821 m
1 .23821 L
s
.99625 .25788 m
1 .25788 L
s
.99625 .27755 m
1 .27755 L
s
.99625 .31688 m
1 .31688 L
s
.99625 .33655 m
1 .33655 L
s
.99625 .35622 m
1 .35622 L
s
.99625 .37589 m
1 .37589 L
s
.99625 .41522 m
1 .41522 L
s
.99625 .43489 m
1 .43489 L
s
.99625 .45456 m
1 .45456 L
s
.99625 .47422 m
1 .47422 L
s
.99625 .51356 m
1 .51356 L
s
.99625 .53323 m
1 .53323 L
s
.99625 .55289 m
1 .55289 L
s
.99625 .57256 m
1 .57256 L
s
.99625 .6119 m
1 .6119 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .15451 m
.06244 .15451 L
.10458 .15451 L
.14415 .15451 L
.18221 .15451 L
.22272 .15451 L
.26171 .15451 L
.30316 .15451 L
.34309 .15451 L
.3815 .15451 L
.42237 .15451 L
.46172 .15451 L
.49955 .15451 L
.53984 .15451 L
.57861 .15451 L
.61984 .15451 L
.65954 .15451 L
.69774 .15451 L
.73838 .15451 L
.77751 .15451 L
.81909 .15451 L
.85916 .15451 L
.89771 .15451 L
.93871 .15451 L
.97619 .15451 L
s
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.02381 .46353 m
.06244 .46353 L
.10458 .46353 L
.14415 .46353 L
.18221 .46353 L
.22272 .46353 L
.26171 .46353 L
.30316 .46353 L
.34309 .46353 L
.3815 .46353 L
.42237 .46353 L
.46172 .46353 L
.49955 .46353 L
.53984 .46353 L
.57861 .46353 L
.61984 .46353 L
.65954 .46353 L
.69774 .46353 L
.73838 .46353 L
.77751 .46353 L
.81909 .46353 L
.85916 .46353 L
.89771 .46353 L
.93871 .46353 L
.97619 .46353 L
s
.02381 .52022 m
.06244 .50363 L
.10458 .48555 L
.14415 .46859 L
.18221 .4523 L
.22272 .43497 L
.26171 .41832 L
.30316 .40063 L
.34309 .38361 L
.3815 .36725 L
.42237 .34987 L
.46172 .33315 L
.49955 .3171 L
.53984 .30002 L
.57861 .2836 L
.61984 .26616 L
.65954 .24938 L
.69774 .23326 L
.73838 .21612 L
.77751 .19964 L
.81909 .18214 L
.85916 .1653 L
.89771 .14912 L
.93871 .13193 L
.97619 .11623 L
s
.02381 .53934 m
.06244 .52282 L
.10458 .50481 L
.14415 .48792 L
.18221 .4717 L
.22272 .45444 L
.26171 .43785 L
.30316 .42024 L
.34309 .40329 L
.3815 .387 L
.42237 .36969 L
.46172 .35304 L
.49955 .33705 L
.53984 .32004 L
.57861 .30369 L
.61984 .28632 L
.65954 .26961 L
.69774 .25355 L
.73838 .23648 L
.77751 .22007 L
.81909 .20264 L
.85916 .18587 L
.89771 .16975 L
.93871 .15263 L
.97619 .13699 L
s
.02381 .55828 m
.06244 .54182 L
.10458 .52389 L
.14415 .50707 L
.18221 .49091 L
.22272 .47373 L
.26171 .45721 L
.30316 .43967 L
.34309 .42279 L
.3815 .40657 L
.42237 .38933 L
.46172 .37274 L
.49955 .35682 L
.53984 .33987 L
.57861 .32359 L
.61984 .30629 L
.65954 .28965 L
.69774 .27365 L
.73838 .25665 L
.77751 .24031 L
.81909 .22295 L
.85916 .20625 L
.89771 .19019 L
.93871 .17314 L
.97619 .15756 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00<oooool3
o`0000?ooooo0ol00003ooooo`?o00001?ooool2o`0002Cooooo0ol00003ooooo`;o00001Oooool2
o`0000Cooooo0_l0000Uooooo`?o00000oooool2o`0000Cooooo0ol00004ooooo`;o00008oooool5
o`0000?ooooo0_l00004ooooo`;o00001?ooool2o`0002cooooo000dooooo`05o`000?oooooooooo
ooooool000000oooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool08_ooool00ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool00000
0_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo02?ooooo00?o0000oooooooo
ool01?ooool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000
ooooooooool08Oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo
00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0000[ooooo`00=?ooool01Ol0003o
oooooooooooooooo000000?ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool08oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`0Rooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0002_ooooo000dooooo`03o`000?oooooo
oooo00;ooooo0ol00006ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool08_oo
ool00ol0003oooooooooo`02ooooo`Co00000_ooool01?l0003oooooooooool00002ooooo`04o`00
0?ooooooooooo`0002Gooooo00?o0000ooooooooool00_ooool4o`0000Gooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`0Sooooo`05o`000?ooooooooooooooool000000_ooool0
1?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
:Oooool003Cooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooo000000?o0000
0oooool01?l0003oooooooooool0000Tooooo`05o`000?ooooooooooooooool000000oooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool08ooo
ool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooool000000ol00003ooooo`04o`00
0?ooooooooooo`0002;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0000[ooooo`00<ooo
ool2o`0000?ooooo00Oo0000ooooooooooooooooo`000?oooooo000000Kooooo00Co0000oooooooo
oooo00008oooool2o`0000?ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00009?ooool2o`0000?ooooo00Oo0000oooooooooooo
ooooo`000?oooooo000000Kooooo00Co0000oooooooooooo00008_ooool01Ol0003ooooooooooooo
oooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04
o`000?ooooooooooo`0002_ooooo000dooooo`03o`000?oooooooooo00;ooooo0ol00002ooooo`Go
00000oooool2o`0002Gooooo00?o0000ooooooooool00_ooool3o`0000Cooooo0_l00004ooooo`;o
00009_ooool00ol0003oooooooooo`02ooooo`?o00000_ooool5o`0000?ooooo0_l0000Tooooo`?o
00001?ooool2o`0000Cooooo0_l00004ooooo`;o0000;?ooool00?oooooo8Oooool00?oooooo8Ooo
ool000Sooooo0_l00004ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`3oooooo`Cooooo0007ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`3oooooo`Cooooo0007ooooo`04o`000?oooooooooo
o`0000[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooooko00000Oooool0
00Oooooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`7o00000Oooool0
00Oooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0n_ooool1o`00007ooooo0007ooooo`04o`000?oooooooooo
o`0000Oooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`3jooooo`7o00000Oooool000Sooooo0_l00008ooooo`Go000000?o
ooooo`000?l000000ol00004ooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`008Oooool2
o`000?[ooooo0_l00001ooooo`008Oooool00ol0003oooooooooo`3jooooo`7o00000Oooool0027o
oooo00?o0000ooooooooool0n_ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo0?[ooooo
0Ol00001ooooo`008Oooool00ol0003oooooooooo`3jooooo`7o00000Oooool0027ooooo0_l0003j
ooooo`;o00000Oooool0027ooooo00?o0000ooooooooool0n_ooool1o`00007ooooo000Qooooo`03
o`000?oooooooooo0?[ooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`3jooooo`7o0000
0Oooool0027ooooo00?o0000ooooooooool0n_ooool1o`00007ooooo000Qooooo`;o0000n_ooool2
o`00007ooooo000Qooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`008Oooool00ol0003o
ooooooooo`3jooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0n_ooool1o`00007ooooo
000Qooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`008Oooool2o`000?[ooooo0_l00001
ooooo`008Oooool00ol0003oooooooooo`3jooooo`7o00000Oooool0027ooooo00?o0000oooooooo
ool0n_ooool1o`00007ooooo0002ooooo`;o00001?ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000ooooooooool0
n_ooool1o`00007ooooo00001Ooooooo0000oooooooooooo000000Wooooo00?o0000ooooooooool0
0oooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`3jooooo`7o00000Oooool00005ooooool0003oooooooooool000002_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool2o`000?[o
oooo0_l00001ooooo`0000Goooooo`000?ooooooooooo`00000:ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?[o
oooo0Ol00001ooooo`0000Goooooo`000?ooooooooooo`00000;ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooool000000ol00005ooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`00
00Goooooo`000?ooooooooooo`000007ooooo`07o`000?ooooooooooooooool0003oooooo`000003
ooooo`03o`000?oooooo000000Sooooo00?o0000ooooooooool0n_ooool1o`00007ooooo0002oooo
o`;o00002?ooool5o`000003ooooool0003o000000?o000000?oooooo`000?l000000ol00004oooo
o`03o`000?oooooooooo0??ooooo0_l00005ooooo`7o00000Oooool0027ooooo0_l0003booooo`;o
00001_ooool2o`00007ooooo000Qooooo`03o`000?oooooooooo0>kooooo0ol00009ooooo`7o0000
0Oooool0027ooooo00?o0000ooooooooool0k?ooool2o`0000cooooo0Ol00001ooooo`008Oooool0
0ol0003oooooooooo`3Zooooo`;o00003_ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo
0>Sooooo0_l00009ooooo`;o00001Oooool1o`00007ooooo000Qooooo`;o0000i_ooool3o`0000Wo
oooo0_l00006ooooo`;o00000Oooool0027ooooo00?o0000ooooooooool0hoooool2o`0000Wooooo
0ol00009ooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0hOooool2o`0000Wooooo0_l0
000<ooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0goooool2o`0000Wooooo0_l0000>
ooooo`7o00000Oooool0027ooooo00?o0000ooooooooool00oooooobo`0000Gooooo0Ol00001oooo
o`008Oooool2o`000=_ooooo0ol00008ooooo`?o00002oooool2o`0000Cooooo0_l00001ooooo`00
8Oooool00ol0003oooooooooo`3Hooooo`;o00002Oooool2o`0000cooooo0_l00007ooooo`7o0000
0Oooool0027ooooo00?o0000ooooooooool0e_ooool2o`0000Wooooo0_l0000;ooooo`?o00002Ooo
ool1o`00007ooooo000Qooooo`03o`000?oooooooooo0=?ooooo0ol00009ooooo`;o00002oooool2
o`0000cooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`3@ooooo`?o00002_ooool2o`00
00_ooooo0_l0000>ooooo`7o00000Oooool0027ooooo0_l0003>ooooo`?o00002_ooool3o`0000[o
oooo0ol0000?ooooo`;o00000Oooool0027ooooo00?o0000ooooooooool0boooool2o`0000_ooooo
0_l0000:ooooo`?o00004oooool1o`00007ooooo000Qooooo`03o`000?oooooooooo0<Sooooo0ol0
000;ooooo`;o00002Oooool3o`0001Kooooo0Ol00001ooooo`002?ooool2o`0000Cooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`36
ooooo`;o00002oooool3o`0000Wooooo0_l0000Iooooo`7o00000Oooool000Oooooo00Co0000oooo
oooooooo00002Oooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`33ooooo`?o00002_ooool3o`0000[ooooo0_l0000Kooooo`7o00000Ooo
ool000Oooooo00Co0000oooooooooooo00002_ooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00;ooooo0_l00032ooooo`;o00002_ooool3o`0000[ooooo0ol0000Looooo`;o0000
0Oooool000Oooooo00Co0000oooooooooooo00002_ooool01?l0003oooooooooooooool3o`0000Go
oooo00?o0000ooooooooool0_oooool2o`0000[ooooo0_l0000;ooooo`;o00008?ooool1o`00007o
oooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooool000000oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo0;gooooo0_l0000:ooooo`;o00002oooool2o`0002;o
oooo0Ol00001ooooo`001oooool01?l0003oooooooooool00007ooooo`07o`000?oooooooooooooo
ool0003oooooo`000003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0^oooool2
o`0000[ooooo0_l0000:ooooo`?o00009?ooool1o`00007ooooo0008ooooo`;o00002?ooool5o`00
00;ooooo0ol00005ooooo`03o`000?oooooooooo0;Wooooo0_l0000:ooooo`;o00002Oooool3o`00
02Oooooo0Ol00001ooooo`008Oooool2o`000;Sooooo0_l0000:ooooo`;o00002?ooool3o`0002Wo
oooo0_l00001ooooo`008Oooool00ol0003oooooooooo`2dooooo`?o00002_ooool2o`0000Sooooo
0_l0000]ooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0/_ooool2o`0000[ooooo0ol0
0008ooooo`;o0000;oooool1o`00007ooooo000Qooooo`03o`000?oooooooooo0:oooooo0ol0000:
ooooo`;o00002Oooool2o`00037ooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`2]oooo
o`;o00002_ooool3o`0000Wooooo0_l0000cooooo`7o00000Oooool0027ooooo0_l0002[ooooo`?o
00002_ooool2o`0000[ooooo0_l0000dooooo`;o00000Oooool0027ooooo00?o0000ooooooooool0
Z?ooool2o`0000[ooooo0ol0000:ooooo`;o0000=oooool1o`00007ooooo000Qooooo`03o`000?oo
oooooooo0:Gooooo0ol0000:ooooo`;o00002_ooool3o`0003Wooooo0Ol00001ooooo`008Oooool0
0ol0003oooooooooo`2Sooooo`;o00002_ooool3o`0000[ooooo0_l0000looooo`7o00000Oooool0
027ooooo00?o0000ooooooooool0X?ooool3o`0000[ooooo0_l0000:ooooo`?o0000?_ooool1o`00
007ooooo000Qooooo`;o0000Woooool2o`0000[ooooo0ol0000:ooooo`;o0000@?ooool2o`00007o
oooo000Qooooo`03o`000?oooooooooo09_ooooo0ol0000:ooooo`;o00002_ooool3o`0004?ooooo
0Ol00001ooooo`008Oooool00ol0003oooooooooo`2Iooooo`;o00002_ooool3o`0000[ooooo0_l0
0016ooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0Uoooool2o`0000[ooooo0_l0000:
ooooo`?o0000B?ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo09Cooooo0ol00009oooo
o`?o00002_ooool2o`0004_ooooo0Ol00001ooooo`008Oooool2o`0009?ooooo0_l0000:ooooo`;o
00002_ooool3o`0004cooooo0_l00001ooooo`008Oooool00ol0003oooooooooo`2@ooooo`;o0000
2Oooool3o`0000[ooooo0_l0001@ooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0S_oo
ool2o`0000Wooooo0_l0000:ooooo`?o0000D_ooool1o`00007ooooo0002ooooo`;o00001?ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo0ol00003ooooo`?o00001Oooool0
0ol0003oooooooooo`2<ooooo`;o00002Oooool2o`0000[ooooo0_l0001Eooooo`7o00000Oooool0
0005ooooool0003oooooooooool000002Oooool01Ol0003ooooooooooooooooo000000?ooooo00?o
0000ooooool000000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo08Wooooo0ol0
0008ooooo`?o00002Oooool3o`0005Oooooo0Ol00001ooooo`0000Goooooo`000?ooooooooooo`00
000:ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`02ooooo`;o0000R?ooool2o`0000Wooooo0_l0000:ooooo`;o0000FOooool2o`00007ooooo
00001Ooooooo0000oooooooooooo000000[ooooo00Co0000oooooooooooooooo0ol00006ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool0QOooool2o`0000Wooooo0_l00009ooooo`?o
0000G?ooool1o`00007ooooo00001Ooooooo0000oooooooooooo000000_ooooo00?o0000ooooool0
00000oooool00ol0003oooooo`000003o`0000Gooooo00?o0000ooooooooool0P_ooool3o`0000Wo
oooo0_l00009ooooo`;o0000Goooool1o`00007ooooo00001Ooooooo0000oooooooooooo000000Oo
oooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o0000ooooool000002?ooool0
0ol0003oooooooooo`03oooooo;o00001Oooool1o`00007ooooo0002ooooo`;o00002?ooool5o`00
00;ooooo0ol00002ooooo`Go00001?ooool00ol0003oooooooooo`1looooo`?o00002_ooool3o`00
00Sooooo0ol0001Sooooo`7o00000Oooool0027ooooo0_l0001kooooo`;o00002oooool2o`0000Wo
oooo0_l0001Uooooo`;o00000Oooool0027ooooo00?o0000ooooooooool0N?ooool2o`0000_ooooo
0_l00009ooooo`;o0000J?ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo07Gooooo0ol0
000:ooooo`?o00002Oooool2o`0006[ooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`1c
ooooo`;o00002_ooool3o`0000[ooooo0_l0001/ooooo`7o00000Oooool0027ooooo00?o0000oooo
ooooool0LOooool2o`0000Wooooo0ol0000:ooooo`?o0000K_ooool1o`00007ooooo000Qooooo`;o
0000Koooool3o`0000Wooooo0_l0000;ooooo`;o0000L?ooool2o`00007ooooo000Qooooo`03o`00
0?oooooooooo06cooooo0_l0000:ooooo`;o00002oooool2o`0007?ooooo0Ol00001ooooo`008Ooo
ool00ol0003oooooooooo`1Yooooo`?o00002Oooool3o`0000[ooooo0ol0001eooooo`7o00000Ooo
ool0027ooooo00?o0000ooooooooool0Ioooool2o`0000[ooooo0_l0000:ooooo`?o0000N?ooool1
o`00007ooooo000Qooooo`03o`000?oooooooooo06Gooooo0_l0000:ooooo`;o00002Oooool3o`00
07_ooooo0Ol00001ooooo`008Oooool2o`0006?ooooo0ol0000:ooooo`;o00002Oooool2o`0007go
oooo0_l00001ooooo`008Oooool00ol0003oooooooooo`1Pooooo`;o00002oooool2o`0000Wooooo
0_l00020ooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0G_ooool2o`0000_ooooo0_l0
0008ooooo`?o0000P_ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo05cooooo0_l0000;
ooooo`;o00002?ooool2o`0008Gooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`1Joooo
o`;o00002oooool2o`0000Sooooo0_l00027ooooo`7o00000Oooool0027ooooo0_l0001Hooooo`?o
00002_ooool3o`0000Oooooo0ol00028ooooo`;o00000Oooool0027ooooo00?o0000ooooooooool0
EOooool2o`0000[ooooo0ol00008ooooo`;o0000S?ooool1o`00007ooooo000Qooooo`03o`000?oo
oooooooo05?ooooo0_l00009ooooo`?o00002?ooool3o`0008kooooo0Ol00001ooooo`002?ooool2
o`0000Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`;o00001_ooool0
0ol0003oooooooooo`1@ooooo`?o00002Oooool2o`0000Wooooo0_l0002Aooooo`7o00000Oooool0
00Oooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0C_ooool2o`0000[ooooo0_l00009ooooo`;o0000Toooool1
o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`02ooooo`;o0000C?ooool3o`0000Wooooo0ol00008ooooo`?o0000U?ooool2
o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000[ooooo00Co0000oooooooooooooooo1?l0
0004ooooo`03o`000?oooooooooo04Wooooo0_l0000:ooooo`;o00002Oooool2o`0009Sooooo0Ol0
0001ooooo`001oooool01?l0003oooooooooool0000;ooooo`03o`000?oooooo000000?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`17ooooo`;o00002_ooool2o`0000Wooooo0_l0
002Jooooo`7o00000Oooool000Oooooo00Co0000oooooooooooo00001oooool01ol0003ooooooooo
oooooooo0000ooooool000000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo04Co
oooo0ol00009ooooo`?o00002Oooool2o`0009cooooo0Ol00001ooooo`002?ooool2o`0000Sooooo
1Ol00002ooooo`?o00001Oooool00ol0003oooooooooo`12ooooo`;o00002_ooool2o`0000[ooooo
0_l0002Nooooo`7o00000Oooool0027ooooo0_l00011ooooo`;o00002Oooool3o`0000Wooooo0ol0
002Oooooo`;o00000Oooool0027ooooo00?o0000ooooooooool0?_ooool2o`0000Wooooo0_l0000:
ooooo`;o0000Xoooool1o`00007ooooo000Qooooo`03o`000?oooooooooo03_ooooo0ol00009oooo
o`;o00002_ooool2o`000:Gooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`0iooooo`;o
00002Oooool3o`0000Wooooo0ol0002Wooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0
=_ooool3o`0000Wooooo0_l0000:ooooo`;o0000Z_ooool1o`00007ooooo000Qooooo`;o0000=Ooo
ool2o`0000[ooooo0_l00009ooooo`?o0000Zoooool2o`00007ooooo000Qooooo`03o`000?oooooo
oooo037ooooo0ol0000:ooooo`;o00002Oooool2o`000:oooooo0Ol00001ooooo`008Oooool00ol0
003oooooooooo`0_ooooo`;o00002_ooool3o`0000Wooooo0_l0002aooooo`7o00000Oooool0027o
oooo00?o0000ooooooooool0;?ooool3o`0000[ooooo0_l00009ooooo`?o0000/oooool1o`00007o
oooo000Qooooo`03o`000?oooooooooo02[ooooo0_l0000:ooooo`?o00002Oooool2o`000;Kooooo
0Ol00001ooooo`008Oooool2o`0002Wooooo0_l0000:ooooo`;o00002_ooool2o`000;Oooooo0_l0
0001ooooo`008Oooool00ol0003oooooooooo`0Vooooo`;o00002Oooool3o`0000[ooooo0_l0002j
ooooo`7o00000Oooool0027ooooo00?o0000ooooooooool00oooooobo`0000Gooooo0Ol00001oooo
o`008Oooool00ol0003oooooooooo`0Rooooo`;o00002?ooool3o`0000[ooooo0_l0002oooooo`7o
00000Oooool0027ooooo00?o0000ooooooooool08?ooool2o`0000Sooooo0_l0000:ooooo`?o0000
`Oooool1o`00007ooooo000Qooooo`;o00007_ooool3o`0000Sooooo0_l0000:ooooo`;o0000`ooo
ool2o`00007ooooo000Qooooo`03o`000?oooooooooo01_ooooo0_l00009ooooo`;o00002Oooool3
o`000<Kooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`0Hooooo`?o00002Oooool2o`00
00Wooooo0_l00039ooooo`7o00000Oooool000;ooooo0_l00004ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool00_ooool2o`0000Cooooo0ol00005ooooo`03o`000?oooooooooo01Ko
oooo0_l0000:ooooo`;o00002?ooool3o`000<_ooooo0Ol00001ooooo`0000Goooooo`000?oooooo
ooooo`000009ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00000oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo01?ooooo0ol0000:ooooo`;o00002?ooool2o`00
0<kooooo0Ol00001ooooo`0000Goooooo`000?ooooooooooo`00000:ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`;o00004_ooool2o`00
00[ooooo0ol00007ooooo`?o0000coooool2o`00007ooooo00001Ooooooo0000oooooooooooo0000
00[ooooo00Co0000oooooooooooooooo1?l00005ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool03_ooool3o`0000[ooooo0_l00008ooooo`;o0000doooool1o`00007ooooo00001Ooo
oooo0000oooooooooooo000000_ooooo00?o0000ooooool000000oooool00ol0003oooooo`000003
o`0000Gooooo00?o0000ooooooooool03?ooool2o`0000[ooooo0ol00007ooooo`?o0000eOooool1
o`00007ooooo00001Ooooooo0000oooooooooooo000000Oooooo00Oo0000ooooooooooooooooo`00
0?oooooo000000?ooooo00?o0000ooooool000002?ooool00ol0003oooooooooo`0:ooooo`;o0000
2_ooool2o`0000Sooooo0_l0003Hooooo`7o00000Oooool000;ooooo0_l00008ooooo`Go00000_oo
ool3o`0000;ooooo1Ol00004ooooo`03o`000?oooooooooo00Sooooo0_l00009ooooo`?o00002?oo
ool2o`000=[ooooo0Ol00001ooooo`008Oooool2o`0000Oooooo0_l00009ooooo`;o00002Oooool2
o`000=_ooooo0_l00001ooooo`008Oooool00ol0003oooooooooo`04ooooo`;o00002?ooool3o`00
00Wooooo0_l0003Nooooo`7o00000Oooool0027ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`06ooooo`;o00002_ooool2o`000>3ooooo0Ol00001ooooo`008Oooool00ol0003ooooo
ooooo`0:ooooo`;o00002_ooool2o`000>;ooooo0Ol00001ooooo`008Oooool00ol0003ooooooooo
o`08ooooo`;o00002Oooool3o`000>Cooooo0Ol00001ooooo`008Oooool2o`0000Oooooo0_l00009
ooooo`;o0000i_ooool2o`00007ooooo000Qooooo`03o`000?oooooooooo00Cooooo0_l00008oooo
o`?o0000jOooool1o`00007ooooo000Qooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool01_ooool2o`000>cooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`09ooooo`?o0000
k_ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo00Oooooo0_l0003aooooo`7o00000Ooo
ool0027ooooo0_l00005ooooo`?o0000l_ooool2o`00007ooooo000Qooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0m?ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo0?[o
oooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`3jooooo`7o00000Oooool0027ooooo00?o
0000ooooooooool0n_ooool1o`00007ooooo000Qooooo`;o0000n_ooool2o`00007ooooo000Qoooo
o`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`003_ooool2o`0000Cooooo00?o0000oooooooo
ool00_ooool3o`0000Gooooo00?o0000ooooooooool0n_ooool1o`00007ooooo000=ooooo`04o`00
0?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo
0?[ooooo0Ol00001ooooo`003Oooool01?l0003oooooooooool00007ooooo`05o`000?oooooooooo
ooooool000001?ooool00ol0003oooooooooo`3jooooo`7o00000Oooool000gooooo00Co0000oooo
oooooooo00002?ooool3o`0000Gooooo0_l0003jooooo`;o00000Oooool000gooooo00Co0000oooo
oooooooo00001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0n_oo
ool1o`00007ooooo000=ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooooooooooo
o`000004ooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`003_ooool2o`0000Wooooo0ol0
0005ooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`3j
ooooo`7o00000Oooool0027ooooo0_l0000Kooooo`03o`000?oooooooooo03Kooooo00?o0000oooo
ooooool0=oooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo033ooooo0_l00001oooo
o`008Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo0Ol00001ooooo`00
8Oooooono`00007ooooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {1795.92, 0.766647, 0.869132, \
0.000200413}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(pts = 
        Graphics[{PointSize[0.022], Point[{1870, y2[1870]}], 
            Point[{1950, y2[1950]}], Point[{2031, y2[2031]}]}];\)\)], "Input"],

Cell[BoxData[
    \(\(txt = 
        Graphics[{Text["\<h=5570\>", {1870, 1.008  f}, {0, 1}], 
            Text["\<h=5630\>", {1870, 1.0182  f}, {0, 1}]}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[p1, pts, txt, 
      FrameTicks \[Rule] {{1870, 1950, 2031}, None, 
          None, {{ .99  f, "\<0.99f\>"}, {f, "\<1.00f\>"}, {1.01  
                f, "\<1.01f\>"}}}, 
      FrameLabel \[Rule] {"\<Years BP\>", "\<Amount\n Present\>"}, 
      RotateLabel \[Rule] False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-8.27551 0.00453515 -15.1418 19.6676 [
[.20522 -0.0125 -12 -9 ]
[.20522 -0.0125 12 0 ]
[.56803 -0.0125 -12 -9 ]
[.56803 -0.0125 12 0 ]
[.93537 -0.0125 -12 -9 ]
[.93537 -0.0125 12 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -26 -21 ]
[.5 -0.0125 26 -9 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -52 -12.25 ]
[-0.01875 .30902 0 12.25 ]
[ 0 .61803 .125 0 ]
[1.0125 .15451 0 -6 ]
[1.0125 .15451 34 6 ]
[1.0125 .30902 0 -6 ]
[1.0125 .30902 34 6 ]
[1.0125 .46353 0 -6 ]
[1.0125 .46353 34 6 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.20522 0 m
.20522 .00625 L
s
[(1870)] .20522 -0.0125 0 1 Mshowa
.56803 0 m
.56803 .00625 L
s
[(1950)] .56803 -0.0125 0 1 Mshowa
.93537 0 m
.93537 .00625 L
s
[(2031)] .93537 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
gsave
.5 -0.0125 -87 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Years) show
99.000 13.000 moveto
(BP) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -113 -16.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 32.5 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Amount) show
69.000 25.500 moveto
(Present) show
111.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .61803 m
1 .61803 L
s
.99375 .15451 m
1 .15451 L
s
gsave
1.0125 .15451 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.99) show
87.000 13.000 moveto
(f) show
93.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .30902 m
1 .30902 L
s
gsave
1.0125 .30902 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.00) show
87.000 13.000 moveto
(f) show
93.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .46353 m
1 .46353 L
s
gsave
1.0125 .46353 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.01) show
87.000 13.000 moveto
(f) show
93.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .15451 m
.06244 .15451 L
.10458 .15451 L
.14415 .15451 L
.18221 .15451 L
.22272 .15451 L
.26171 .15451 L
.30316 .15451 L
.34309 .15451 L
.3815 .15451 L
.42237 .15451 L
.46172 .15451 L
.49955 .15451 L
.53984 .15451 L
.57861 .15451 L
.61984 .15451 L
.65954 .15451 L
.69774 .15451 L
.73838 .15451 L
.77751 .15451 L
.81909 .15451 L
.85916 .15451 L
.89771 .15451 L
.93871 .15451 L
.97619 .15451 L
s
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.02381 .46353 m
.06244 .46353 L
.10458 .46353 L
.14415 .46353 L
.18221 .46353 L
.22272 .46353 L
.26171 .46353 L
.30316 .46353 L
.34309 .46353 L
.3815 .46353 L
.42237 .46353 L
.46172 .46353 L
.49955 .46353 L
.53984 .46353 L
.57861 .46353 L
.61984 .46353 L
.65954 .46353 L
.69774 .46353 L
.73838 .46353 L
.77751 .46353 L
.81909 .46353 L
.85916 .46353 L
.89771 .46353 L
.93871 .46353 L
.97619 .46353 L
s
.02381 .52022 m
.06244 .50363 L
.10458 .48555 L
.14415 .46859 L
.18221 .4523 L
.22272 .43497 L
.26171 .41832 L
.30316 .40063 L
.34309 .38361 L
.3815 .36725 L
.42237 .34987 L
.46172 .33315 L
.49955 .3171 L
.53984 .30002 L
.57861 .2836 L
.61984 .26616 L
.65954 .24938 L
.69774 .23326 L
.73838 .21612 L
.77751 .19964 L
.81909 .18214 L
.85916 .1653 L
.89771 .14912 L
.93871 .13193 L
.97619 .11623 L
s
.02381 .53934 m
.06244 .52282 L
.10458 .50481 L
.14415 .48792 L
.18221 .4717 L
.22272 .45444 L
.26171 .43785 L
.30316 .42024 L
.34309 .40329 L
.3815 .387 L
.42237 .36969 L
.46172 .35304 L
.49955 .33705 L
.53984 .32004 L
.57861 .30369 L
.61984 .28632 L
.65954 .26961 L
.69774 .25355 L
.73838 .23648 L
.77751 .22007 L
.81909 .20264 L
.85916 .18587 L
.89771 .16975 L
.93871 .15263 L
.97619 .13699 L
s
.02381 .55828 m
.06244 .54182 L
.10458 .52389 L
.14415 .50707 L
.18221 .49091 L
.22272 .47373 L
.26171 .45721 L
.30316 .43967 L
.34309 .42279 L
.3815 .40657 L
.42237 .38933 L
.46172 .37274 L
.49955 .35682 L
.53984 .33987 L
.57861 .32359 L
.61984 .30629 L
.65954 .28965 L
.69774 .27365 L
.73838 .25665 L
.77751 .24031 L
.81909 .22295 L
.85916 .20625 L
.89771 .19019 L
.93871 .17314 L
.97619 .15756 L
s
.022 w
.20522 .4619 Mdot
.56803 .30815 Mdot
.93537 .15402 Mdot
gsave
.20522 .43262 -81 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
69.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5570) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.20522 .59022 -81 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
69.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5630) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{356.625, 220.438},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005T0000g2000`400?l00000o`00003ooooooomU
ooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomU
ooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomU
ooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomU
ooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomU
ooooo`00Y?ooool3o`0000?ooooo0ol00003ooooo`Co000000Coooooo`000?l0003o00000oooool4
o`0000Sooooo1?l00002ooooo`?o0000U?ooool00:Gooooo00Go0000ooooooooooooooooo`000005
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0Toooool00:Gooooo00Co
0000oooooooooooooooo1Ol00002ooooo`?o00000oooool00ol0003oooooooooo`03ooooo`?o0000
2Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo09?ooooo002Uooooo`05o`00
0?ooooooooooooooool000000oooool00ol0003oooooo`000002ooooo`04o`000?oooooooooooooo
o`;o00000oooool00ol0003oooooooooo`0:ooooo`?o00000oooool3o`0009?ooooo002Tooooo`03
o`000?oooooo000000?ooooo0ol00003ooooo`;o00000oooool2o`000003ooooool0003o000000;o
oooo1?l00008ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000T_ooool0
0:Cooooo00?o0000ooooool000008Oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0009;ooooo002Sooooo`;o000000?oooooo`000?l000007oooool4o`0000;ooooo1?l0002C
ooooo`00oooooomUooooo`00oooooomUooooo`00Hoooool3o`0000?ooooo0ol00004ooooo`03o`00
0?oooooooooo00?ooooo0_l0001:ooooo`?o00000oooool2o`0000Cooooo0ol00004ooooo`;o0000
B_ooool5o`0000?ooooo0_l00003ooooo`?o00000oooool3o`0002gooooo001Tooooo`05o`000?oo
ooooooooooooool000000oooool01Ol0003ooooooooooooooooo000000Cooooo00Co0000oooooooo
oooo0000B_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`18ooooo`04o`000?ooooooooooo`0000;ooooo
00Ko0000oooooooooooo0000ooooool00003ooooo`05o`000?ooooooooooooooool00000;_ooool0
06Cooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00;ooooo00Go0000
ooooooooooooooooo`000002ooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
BOooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Gooooo00Go0000oooooooo
ooooooooo`00000^ooooo`00I?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooooooool0B?ooool00ol0003oooooooooo`02oooo
o`Co00001Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo04[ooooo00Go0000
ooooooooooooooooo`000002ooooo`04o`000?ooooooooooooooo`;o00001?ooool00ol0003ooooo
ooooo`0/ooooo`00I?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool0
0oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo04Sooooo00Go0000oooooooo
ooooooooo`000003ooooo`03o`000?oooooo000000?o00000oooool01?l0003oooooooooool00019
ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00005ooooo`05o`00
0?ooooooooooooooool00000;_ooool006?ooooo0_l00003ooooo`07o`000?ooooooooooooooool0
003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0Aoooool2
o`0000?ooooo00Oo0000ooooooooooooooooo`000?oooooo000000Kooooo00Co0000oooooooooooo
0000BOooool01Ol0003ooooooooooooooooo000000;ooooo00Ko0000oooooooooooo0000ooooool0
0003ooooo`03o`000?oooooooooo00;o0000;_ooool006Cooooo00?o0000ooooooooool00_ooool3
o`0000;ooooo1Ol00003ooooo`;o0000Boooool00ol0003oooooooooo`02ooooo`?o00000_ooool5
o`0000?ooooo0_l0001;ooooo`?o00001?ooool2o`0000?ooooo0ol00004ooooo`03o`000?oooooo
oooo02cooooo003oooooofGooooo003oooooofGooooo003oooooofGooooo003oooooofGooooo000h
oooooooo00002?l0000Uooooo`00>?ooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo
05cooooo00?o0000ooooooooool0GOooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo
02?ooooo000hooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool0G?ooool00ol0003o
ooooooooo`1Mooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool08oooool003Sooooo
00?o0000ooooooooool0ooooool4ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oo
oooooooo0?oooooo1?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3o
ooooo`Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0ooooool4oooo
o`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0?oooooo1?ooool00ol0003o
ooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3oooooo`Cooooo00?o0000ooooooooool0
8oooool003Sooooo00?o0000ooooooooool0ooooool4ooooo`03o`000?oooooooooo02?ooooo000h
ooooo`03o`000?oooooooooo0?oooooo1?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0
003oooooooooo`3oooooo`Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooooooo
ool0ooooool4ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0?oooooo
1?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3oooooo`Cooooo00?o
0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0ooooool4ooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo0?oooooo1?ooool00ol0003oooooooooo`0Soooo
o`00>?ooool00ol0003oooooooooo`3oooooo`Cooooo00?o0000ooooooooool08oooool003Sooooo
00?o0000ooooooooool0ooooool4ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oo
oooooooo0?oooooo1?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3o
ooooo`Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0ooooool4oooo
o`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0?oooooo1?ooool00ol0003o
ooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3oooooo`Cooooo00?o0000ooooooooool0
8oooool003Sooooo00?o0000ooooooooool0ooooool4ooooo`03o`000?oooooooooo02?ooooo000h
ooooo`03o`000?oooooooooo0?oooooo1?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0
003oooooooooo`3oooooo`Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooooooo
ool0ooooool4ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0?oooooo
1?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3oooooo`Cooooo00?o
0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0ooooool4ooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo0?cooooo0_l00005ooooo`03o`000?oooooooooo
02?ooooo000hooooo`03o`000?oooooooooo0?Wooooo0ol00007ooooo`03o`000?oooooooooo02?o
oooo000hooooo`03o`000?oooooooooo0?Oooooo0_l0000:ooooo`03o`000?oooooooooo02?ooooo
000hooooo`03o`000?oooooooooo0?Cooooo0ol0000<ooooo`03o`000?oooooooooo02?ooooo000h
ooooo`03o`000?oooooooooo0?;ooooo0_l0000?ooooo`03o`000?oooooooooo02?ooooo000hoooo
o`03o`000?oooooooooo0>oooooo0ol0000:ooooo`;o00001Oooool00ol0003oooooooooo`0Soooo
o`00>?ooool00ol0003oooooooooo`3/ooooo`?o00002_ooool3o`0000Oooooo00?o0000oooooooo
ool08oooool003Sooooo00?o0000ooooooooool0jOooool3o`0000_ooooo0_l0000:ooooo`03o`00
0?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>Oooooo0_l00008ooooo`Ko00003?oo
ool00ol0003oooooooooo`04ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`;o00001?oo
ool2o`0000?ooooo1Ol00004ooooo`00>?ooool00ol0003oooooooooo`3Tooooo`?o00002Oooool5
o`0000kooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0000:ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`00>?ooool0
0ol0003oooooooooo`04oooooo[o00000oooool3o`0000Gooooo00Co0000oooooooooooo00002ooo
ool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000001_ooool003Sooooo00?o
0000ooooooooool0goooool3o`0000_ooooo2?l00004ooooo`?o00001oooool00ol0003ooooooooo
o`03ooooo`04o`000?ooooooooooo`0000Sooooo1?l00002ooooo`Co00000oooool00ol0003ooooo
ooooo`04ooooo`00>?ooool00ol0003oooooooooo`3Mooooo`;o00003?ooool2o`0000Cooooo0ol0
0003ooooo`;o00002_ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000Oooooo
00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o0000ooooooooool01?l00004oooo
o`00>?ooool00ol0003oooooooooo`3Kooooo`;o00003?ooool2o`0000Wooooo0ol0000<ooooo`03
o`000?oooooooooo00?ooooo00Co0000oooooooooooo00001oooool01ol0003ooooooooooooooooo
0000ooooool000000oooool01Ol0003ooooooooooooooooo000000Kooooo000hooooo`03o`000?oo
oooooooo0=Wooooo0_l0000<ooooo`;o00002Oooool2o`0000oooooo00?o0000ooooooooool01?oo
ool2o`0000Wooooo0ol00003ooooo`?o00001Oooool2o`0000Cooooo000hooooo`03o`000?oooooo
oooo0=Oooooo0_l0000;ooooo`?o00002Oooool2o`00017ooooo00?o0000ooooooooool08oooool0
03Sooooo00?o0000ooooooooool0eOooool2o`0000_ooooo0_l00009ooooo`?o00004oooool00ol0
003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3Cooooo`;o00002_ooool3o`0000Wo
oooo0_l0000Fooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0=3ooooo
0ol0000:ooooo`;o00002_ooool2o`0001Sooooo00?o0000ooooooooool08oooool003Sooooo00?o
0000ooooooooool0cOooool3o`0000[ooooo0ol0000:ooooo`;o00006_ooool00ol0003ooooooooo
o`0Sooooo`00>?ooool00ol0003oooooooooo`3:ooooo`?o00002oooool2o`0000[ooooo0ol0000L
ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0<Sooooo0_l0000;oooo
o`?o00002_ooool2o`0001oooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooooooo
ool0a_ooool2o`0000_ooooo0_l0000:ooooo`?o00008Oooool00ol0003oooooooooo`0Sooooo`00
>?ooool00ol0003oooooooooo`33ooooo`?o00002oooool2o`0000[ooooo0_l0000Tooooo`03o`00
0?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0<7ooooo0_l0000;ooooo`?o00002Ooo
ool3o`0002Kooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0_oooool2
o`0000_ooooo0_l0000:ooooo`;o0000:Oooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0
003oooooooooo`2mooooo`;o00002oooool2o`0000Wooooo0ol0000[ooooo`03o`000?oooooooooo
02?ooooo000hooooo`03o`000?oooooooooo0;[ooooo0ol0000;ooooo`;o00002Oooool2o`0002ko
oooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0^?ooool2o`0000_ooooo
0ol00009ooooo`;o0000<?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooooooo
o`2eooooo`?o00002_ooool3o`0000Wooooo0ol0000booooo`03o`000?oooooooooo02?ooooo000h
ooooo`03o`000?oooooooooo0;?ooooo0_l0000:ooooo`?o00002_ooool2o`0003Gooooo00?o0000
ooooooooool08oooool003Sooooo00?o0000ooooooooool0/?ooool3o`0000[ooooo0_l0000;oooo
o`;o0000=oooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`2^ooooo`;o
00002_ooool3o`0000_ooooo0_l0000iooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`00
0?oooooooooo0:_ooooo0ol0000:ooooo`;o00002oooool3o`0003_ooooo00?o0000ooooooooool0
8oooool003Sooooo00?o0000ooooooooool0ZOooool2o`0000[ooooo0ol0000:ooooo`?o0000?_oo
ool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`2Wooooo`;o00002_ooool2
o`0000[ooooo0ol00011ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo
0:Cooooo0ol0000:ooooo`;o00002_ooool2o`0004Cooooo00?o0000ooooooooool08oooool003So
oooo00?o0000ooooooooool0X_ooool2o`0000_ooooo0_l0000:ooooo`;o0000A_ooool00ol0003o
ooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`2Pooooo`;o00002oooool2o`0000[ooooo
0_l00018ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo09kooooo0_l0
000;ooooo`;o00002_ooool2o`0004[ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000
ooooooooool0Voooool3o`0000_ooooo0_l0000:ooooo`;o0000C?ooool00ol0003oooooooooo`0S
ooooo`00>?ooool00ol0003oooooooooo`2Iooooo`;o00002oooool3o`0000[ooooo0_l0001>oooo
o`03o`000?oooooooooo02?ooooo0008ooooo`?o00000oooool3o`0000Cooooo0ol00002ooooo`Co
00000oooool3o`0000;ooooo0ol000000ooooooo0000o`000002ooooo`;o00002?ooool00ol0003o
ooooooooo`2Fooooo`?o00002_ooool3o`0000[ooooo0ol0001@ooooo`03o`000?oooooooooo02?o
oooo0009ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooo000000Kooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00007ooooo`03o`000?oooooooooo09Cooooo0_l0000:ooooo`?o00002oooool2o`00
05?ooooo00?o0000ooooooooool08oooool000Wooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`02ooooo`Go00000_ooool3o`0000;ooooo1Ol00002ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`2Booooo`;o00002_ooool2o`00
00_ooooo0ol0001Eooooo`03o`000?oooooooooo02?ooooo0009ooooo`?o00000oooool2o`0000?o
oooo00Oo0000ooooooooooooooooo`000?oooooo000000Gooooo00Go0000ooooooooooooooooo`00
0002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`2@ooooo`;o00002_ooool2o`0000_ooooo0_l0001Hooooo`03o`000?oooooooooo02?ooooo
0009ooooo`05o`000?ooooooooooo`000?ooool00_l000000ooooooo0000o`000002ooooo`?o0000
0oooool4o`0000;ooooo0ol00002ooooo`Co00000_ooool4o`0000Sooooo00?o0000ooooooooool0
S_ooool2o`0000[ooooo0_l0000:ooooo`?o0000F_ooool00ol0003oooooooooo`0Sooooo`002Ooo
ool01?l0003oooooooooool0000Pooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
S?ooool2o`0000[ooooo0_l00009ooooo`?o0000GOooool00ol0003oooooooooo`0Sooooo`002?oo
ool4o`00027ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`2:ooooo`;o00001Ooo
ool3o`0000;ooooo0_l00008ooooo`?o0000H?ooool00ol0003oooooooooo`03ooooo`?o00001?oo
ool00ol0003oooooooooo`03ooooo`;o00001?ooool2o`0000;ooooo1Ol00004ooooo`00>?ooool0
0ol0003oooooooooo`27ooooo`?o00001_ooool6o`0000Sooooo0_l0001Sooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool02?ooool01?l0003oooooooooool00002ooooo`04o`000?oo
ooooooooo`0000?ooooo00?o0000ooooooooool01?ooool003Sooooo00?o0000ooooooooool01?oo
ooojo`0000?ooooo0ol00006ooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Cooooo000hooooo`03o`00
0?oooooooooo087ooooo0ol0000;ooooo`Ko00001Oooool2o`0006Oooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooo
oooo00000oooool00ol0003oooooooooo`04ooooo`00>?ooool00ol0003oooooooooo`1oooooo`;o
00002oooool3o`0000;ooooo0ol00004ooooo`;o0000JOooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Sooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002
ooooo`Co00001?ooool003Sooooo00?o0000ooooooooool0O?ooool3o`0000_ooooo0_l0000:oooo
o`;o0000Joooool00ol0003oooooooooo`03ooooo`;o00002_ooool01?l0003oooooooooool00002
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01?ooool000;ooooo0_l00000
0ooooooo0000o`000002o`000004ooooool0003oooooo`0000;ooooo0ol00004ooooo`;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002ooooo`;o00005?ooool00ol0003ooooooooo
o`1jooooo`;o00002oooool3o`0000[ooooo0_l0001]ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool02Oooool2o`0000Cooooo0_l00005ooooo`;o00001?ooool000;ooooo00go0000
ooooooooooooooooo`000?oooooo0000ooooool0003oooooo`000?oooooo000000?ooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1gooooo`?o00002_ooool3o`0000[o
oooo0ol0001_ooooo`03o`000?oooooooooo02?ooooo0002ooooo`Go000000Soooooo`000?oooooo
0000ooooool0003oooooo`0000?ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00002ooooo`04o`000?ooooooooooo`0001Kooooo00?o0000ooooooooool0MOooool2o`0000[o
oooo0ol0000;ooooo`;o0000L_ooool00ol0003oooooooooo`0Sooooo`000oooool00ol0003ooooo
o`000002ooooo`07o`000?oooooo0000ooooool0003oooooo`000003ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0000Fooooo`03o`00
0?oooooooooo07?ooooo0_l0000:ooooo`;o00002oooool3o`0007Cooooo00?o0000ooooooooool0
8oooool000?ooooo00?o0000ooooool000000_ooool2o`000003ooooool0003ooooo00;ooooo0ol0
0002ooooo`;o000000Coooooo`000?l0003ooooo1?l00002ooooo`Co00005?ooool00ol0003ooooo
ooooo`1aooooo`;o00002Oooool3o`0000_ooooo0_l0001gooooo`03o`000?oooooooooo02?ooooo
0004ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool05?ooool00ol0003ooooooooo
o`1_ooooo`;o00002Oooool2o`0000_ooooo0ol0001iooooo`03o`000?oooooooooo02?ooooo0003
ooooo`;o00007?ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo06gooooo0_l00008
ooooo`?o00002_ooool3o`0007cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooo
ooooool0Joooool2o`0000Sooooo0_l0000:ooooo`?o0000Ooooool00ol0003oooooooooo`0Soooo
o`00>?ooool00ol0003oooooooooo`1Xooooo`?o00002?ooool2o`0000[ooooo0_l00022ooooo`03
o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo06Gooooo0ol00009ooooo`;o0000
2_ooool2o`0008Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0H_oo
ool3o`0000[ooooo0_l0000:ooooo`;o0000Q_ooool00ol0003oooooooooo`0Sooooo`00>?ooool0
0ol0003oooooooooo`1Pooooo`;o00002oooool2o`0000[ooooo0_l00028ooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo05gooooo0ol0000;ooooo`;o00002_ooool2o`00
08[ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0Foooool2o`0000_o
oooo0ol0000:ooooo`;o0000S?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooo
ooooo`1Hooooo`?o00002_ooool3o`0000[ooooo0ol0002>ooooo`03o`000?oooooooooo02?ooooo
000hooooo`03o`000?oooooooooo05Kooooo0_l0000:ooooo`?o00002oooool2o`00097ooooo00?o
0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0E?ooool2o`0000[ooooo0_l0000;
ooooo`?o0000Toooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`1Boooo
o`;o00002_ooool2o`0000_ooooo0_l0002Fooooo`03o`000?oooooooooo02?ooooo000hooooo`03
o`000?oooooooooo053ooooo0_l0000:ooooo`;o00002_ooool3o`0009Sooooo00?o0000oooooooo
ool08oooool003Sooooo00?o0000ooooooooool0C_ooool2o`0000[ooooo0_l00009ooooo`?o0000
Voooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Qooooo`Ko000000?o
ooooo`000?l000000_l00002ooooo`?o00000oooool3o`0000Cooooo00?o0000ooooooooool00ooo
ool2o`0000Wooooo0_l0000:ooooo`;o00002?ooool3o`0009kooooo00?o0000ooooooooool08ooo
ool003Sooooo00?o0000ooooooooool08_ooool01?l0003oooooooooool00007ooooo`07o`000?oo
ooooooooooooool0003oooooo`000003ooooo`05o`000?ooooooooooooooool000001?ooool01?l0
003oooooooooool00005ooooo`?o00002_ooool2o`0000Sooooo0_l0002Qooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo02;ooooo00Co0000oooooooooooo00000_ooool4
o`0000Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`05o`000?oooooo
ooooooooool000000_ooool00ol0003oooooooooo`03o`0000[ooooo0ol00008ooooo`;o0000Xooo
ool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Rooooo`04o`000?oooooo
ooooo`0000_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`05o`000?oo
ooooooooooooool000000_ooool3o`0000_ooooo0_l00009ooooo`;o0000YOooool00ol0003ooooo
ooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Rooooo`?o00002?ooool4o`0000;ooooo1?l0
0006ooooo`03o`000?oooooooooo00Co00002_ooool3o`0000Wooooo0_l0002Wooooo`03o`000?oo
oooooooo02?ooooo000hooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00Ko0000ooooooooooooooooo`00
0?ooool2o`0000;ooooo00?o0000ooooooooool01_ooool2o`0000[ooooo0_l0002Yooooo`03o`00
0?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo027ooooo0_l0000:ooooo`Go000000?o
ooooo`000?l000000ol000000ooooooo0000o`000004o`0000;ooooo0_l00007ooooo`;o00002_oo
ool2o`000:_ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0>oooool2
o`0000[ooooo0ol00009ooooo`?o0000[Oooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0
003oooooooooo`0iooooo`;o00002_ooool2o`0000[ooooo0_l0002`ooooo`03o`000?oooooooooo
02?ooooo000hooooo`03o`000?oooooooooo03Oooooo0_l0000:ooooo`;o00002Oooool3o`000;;o
oooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0=?ooool3o`0000[ooooo
0_l00009ooooo`;o0000]Oooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooooooo
o`0aooooo`?o00002_ooool3o`0000Wooooo0_l0002gooooo`03o`000?oooooooooo02?ooooo000h
ooooo`03o`000?oooooooooo02kooooo0ol0000;ooooo`;o00002Oooool3o`000;Wooooo00?o0000
ooooooooool08oooool003Sooooo00?o0000ooooooooool0;?ooool2o`0000_ooooo0ol00009oooo
o`;o0000_?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Zooooo`;o
00001_ooool3o`0000;ooooo0_l0000:ooooo`;o0000__ooool00ol0003oooooooooo`03ooooo`?o
00001?ooool00ol0003oooooooooo`03ooooo`;o00000oooool3o`0000;ooooo1Ol00004ooooo`00
>?ooool00ol0003oooooooooo`0Xooooo`;o00001oooool6o`0000[ooooo0_l00030ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool02?ooool01?l0003oooooooooool00003ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool003Sooooo00?o0000ooooooooool0
1?ooooojo`0000?ooooo0ol00006ooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooooooo
00000oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Cooooo000hooooo`03o`00
0?oooooooooo02Cooooo0_l00008ooooo`So00001_ooool2o`000<Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`04ooooo`00>?ooool00ol0003oooooooooo`0Rooooo`;o0000
2?ooool2o`0000Cooooo0ol00004ooooo`?o0000aoooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Sooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`Co
00001?ooool003Sooooo00?o0000ooooooooool07oooool3o`0000Sooooo0_l0000;ooooo`;o0000
b_ooool00ol0003oooooooooo`03ooooo`;o00002_ooool01?l0003oooooooooool00002ooooo`;o
00001Oooool00ol0003oooooooooo`04ooooo`00>?ooool00ol0003oooooooooo`0Mooooo`;o0000
2Oooool2o`0000[ooooo0ol0003<ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
2Oooool2o`0000Cooooo00?o0000ooooooooool01?ooool2o`0000Cooooo000hooooo`03o`000?oo
oooooooo01[ooooo0ol00009ooooo`;o00002Oooool3o`000<oooooo00?o0000ooooooooool08ooo
ool003Sooooo00?o0000ooooooooool06?ooool2o`0000[ooooo0_l00008ooooo`?o0000d_ooool0
0ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Fooooo`;o00002_ooool2o`00
00Sooooo0_l0003Eooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo01?o
oooo0ol00009ooooo`?o00002?ooool2o`000=Oooooo00?o0000ooooooooool08oooool003Sooooo
00?o0000ooooooooool04Oooool2o`0000[ooooo0_l00009ooooo`;o0000fOooool00ol0003ooooo
ooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0?ooooo`;o00002Oooool3o`0000Wooooo0_l0
003Kooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo00gooooo0_l00009
ooooo`;o00002_ooool2o`000=gooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooo
ooooool02_ooool3o`0000Wooooo0_l0000:ooooo`;o0000goooool00ol0003oooooooooo`0Soooo
o`00>?ooool00ol0003oooooooooo`08ooooo`;o00002Oooool3o`0000Wooooo0ol0003Qooooo`03
o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo00Gooooo0ol00009ooooo`;o0000
2_ooool2o`000>Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`08ooooo`;o00002Oooool3o`000>Kooooo00?o0000ooooooooool08ooo
ool003Sooooo00?o0000ooooooooool03Oooool2o`0000Wooooo0_l0003Yooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo00[ooooo0ol00009ooooo`;o0000joooool00ol0
003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`08ooooo`;o00002Oooool3o`000>go
oooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool01Oooool3o`0000Wooooo
0_l0003`ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool02?ooool2o`000?;ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000
ooooooooool03Oooool2o`000?Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooo
ooooool02_ooool3o`000?Kooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooooooo
ool02?ooool2o`000?Wooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0
1Oooool3o`000?_ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Jooooo`Ko000000?oooooo`000?l000000_l00002ooooo`?o00000ooo
ool3o`0000?ooooo0ol00004ooooo`;o0000`?ooool00ol0003oooooooooo`0Sooooo`00>?ooool0
0ol0003oooooooooo`0Rooooo`04o`000?ooooooooooo`0000Oooooo00Oo0000oooooooooooooooo
o`000?oooooo000000?ooooo00?o0000ooooool000000oooool01?l0003oooooooooool00002oooo
o`03o`000?oooooooooo0;gooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooooooo
ool08_ooool01?l0003oooooooooool00002ooooo`Co00001Oooool00ol0003oooooo`000003oooo
o`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`2m
ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo02;ooooo00Co0000oooo
oooooooo00002oooool00ol0003oooooo`000003o`0000Cooooo0_l00003ooooo`04o`000?oooooo
ooooo`000;oooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool08_ooool3
o`0000Sooooo1?l00002ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooooooo`2mooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooo
oooo02;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`000;oooooo
00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool08Oooool2o`0000[ooooo1Ol0
0003ooooo`;o00000oooool3o`0000Cooooo0_l00030ooooo`03o`000?oooooooooo02?ooooo000h
ooooo`03o`000?oooooooooo0?oooooo1?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0
003oooooooooo`3oooooo`Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooooooo
ool0ooooool4ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0?oooooo
1?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3oooooo`Cooooo00?o
0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0ooooool4ooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo0?oooooo1?ooool00ol0003oooooooooo`0Soooo
o`00>?ooool00ol0003oooooooooo`3oooooo`Cooooo00?o0000ooooooooool08oooool003Sooooo
00?o0000ooooooooool0ooooool4ooooo`03o`000?oooooooooo02?ooooo000hoooooooo00002?l0
000Uooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooo
oomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooo
oomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooooomUooooo`00oooo
oomUooooo`00oooooomUooooo`00\
\>"],
  ImageRangeCache->{{{0, 355.625}, {219.438, 0}} -> {1776.76, 0.7619, \
0.843367, 0.000194472}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Shroud of Turin", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = 0.91825\)], "Input"],

Cell[BoxData[
    \(0.91825`\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[t_] = Exp[\(-Log[2]\)/5570\ t]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-t\)/5570\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[t_] = Exp[\(-Log[2]\)/5600\ t]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-t\)/5600\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y3[t_] = Exp[\(-Log[2]\)/5630\ t]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-t\)/5630\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p1 = 
      Plot[{ .99  f, f, 1.01  f, y1[t], y2[t], y3[t]}, {t, 600, 780}, 
        PlotRange \[Rule] { .98  f, 1.02  f}, Frame \[Rule] True, 
        Axes \[Rule] False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-3.15079 0.00529101 -15.1418 16.8264 [
[.02381 -0.0125 -9 -9 ]
[.02381 -0.0125 9 0 ]
[.15608 -0.0125 -9 -9 ]
[.15608 -0.0125 9 0 ]
[.28836 -0.0125 -9 -9 ]
[.28836 -0.0125 9 0 ]
[.42063 -0.0125 -9 -9 ]
[.42063 -0.0125 9 0 ]
[.55291 -0.0125 -9 -9 ]
[.55291 -0.0125 9 0 ]
[.68519 -0.0125 -9 -9 ]
[.68519 -0.0125 9 0 ]
[.81746 -0.0125 -9 -9 ]
[.81746 -0.0125 9 0 ]
[.94974 -0.0125 -9 -9 ]
[.94974 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .00194 -18 -4.5 ]
[-0.0125 .00194 0 4.5 ]
[-0.0125 .08607 -30 -4.5 ]
[-0.0125 .08607 0 4.5 ]
[-0.0125 .1702 -24 -4.5 ]
[-0.0125 .1702 0 4.5 ]
[-0.0125 .25433 -30 -4.5 ]
[-0.0125 .25433 0 4.5 ]
[-0.0125 .33846 -24 -4.5 ]
[-0.0125 .33846 0 4.5 ]
[-0.0125 .4226 -30 -4.5 ]
[-0.0125 .4226 0 4.5 ]
[-0.0125 .50673 -24 -4.5 ]
[-0.0125 .50673 0 4.5 ]
[-0.0125 .59086 -30 -4.5 ]
[-0.0125 .59086 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(600)] .02381 -0.0125 0 1 Mshowa
.15608 0 m
.15608 .00625 L
s
[(625)] .15608 -0.0125 0 1 Mshowa
.28836 0 m
.28836 .00625 L
s
[(650)] .28836 -0.0125 0 1 Mshowa
.42063 0 m
.42063 .00625 L
s
[(675)] .42063 -0.0125 0 1 Mshowa
.55291 0 m
.55291 .00625 L
s
[(700)] .55291 -0.0125 0 1 Mshowa
.68519 0 m
.68519 .00625 L
s
[(725)] .68519 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(750)] .81746 -0.0125 0 1 Mshowa
.94974 0 m
.94974 .00625 L
s
[(775)] .94974 -0.0125 0 1 Mshowa
.125 Mabswid
.05026 0 m
.05026 .00375 L
s
.07672 0 m
.07672 .00375 L
s
.10317 0 m
.10317 .00375 L
s
.12963 0 m
.12963 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.20899 0 m
.20899 .00375 L
s
.23545 0 m
.23545 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.31481 0 m
.31481 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.36772 0 m
.36772 .00375 L
s
.39418 0 m
.39418 .00375 L
s
.44709 0 m
.44709 .00375 L
s
.47354 0 m
.47354 .00375 L
s
.5 0 m
.5 .00375 L
s
.52646 0 m
.52646 .00375 L
s
.57937 0 m
.57937 .00375 L
s
.60582 0 m
.60582 .00375 L
s
.63228 0 m
.63228 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.71164 0 m
.71164 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.76455 0 m
.76455 .00375 L
s
.79101 0 m
.79101 .00375 L
s
.84392 0 m
.84392 .00375 L
s
.87037 0 m
.87037 .00375 L
s
.89683 0 m
.89683 .00375 L
s
.92328 0 m
.92328 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00194 m
.00625 .00194 L
s
[(0.9)] -0.0125 .00194 1 0 Mshowa
0 .08607 m
.00625 .08607 L
s
[(0.905)] -0.0125 .08607 1 0 Mshowa
0 .1702 m
.00625 .1702 L
s
[(0.91)] -0.0125 .1702 1 0 Mshowa
0 .25433 m
.00625 .25433 L
s
[(0.915)] -0.0125 .25433 1 0 Mshowa
0 .33846 m
.00625 .33846 L
s
[(0.92)] -0.0125 .33846 1 0 Mshowa
0 .4226 m
.00625 .4226 L
s
[(0.925)] -0.0125 .4226 1 0 Mshowa
0 .50673 m
.00625 .50673 L
s
[(0.93)] -0.0125 .50673 1 0 Mshowa
0 .59086 m
.00625 .59086 L
s
[(0.935)] -0.0125 .59086 1 0 Mshowa
.125 Mabswid
0 .01876 m
.00375 .01876 L
s
0 .03559 m
.00375 .03559 L
s
0 .05241 m
.00375 .05241 L
s
0 .06924 m
.00375 .06924 L
s
0 .10289 m
.00375 .10289 L
s
0 .11972 m
.00375 .11972 L
s
0 .13655 m
.00375 .13655 L
s
0 .15337 m
.00375 .15337 L
s
0 .18703 m
.00375 .18703 L
s
0 .20385 m
.00375 .20385 L
s
0 .22068 m
.00375 .22068 L
s
0 .2375 m
.00375 .2375 L
s
0 .27116 m
.00375 .27116 L
s
0 .28798 m
.00375 .28798 L
s
0 .30481 m
.00375 .30481 L
s
0 .32164 m
.00375 .32164 L
s
0 .35529 m
.00375 .35529 L
s
0 .37212 m
.00375 .37212 L
s
0 .38894 m
.00375 .38894 L
s
0 .40577 m
.00375 .40577 L
s
0 .43942 m
.00375 .43942 L
s
0 .45625 m
.00375 .45625 L
s
0 .47307 m
.00375 .47307 L
s
0 .4899 m
.00375 .4899 L
s
0 .52355 m
.00375 .52355 L
s
0 .54038 m
.00375 .54038 L
s
0 .55721 m
.00375 .55721 L
s
0 .57403 m
.00375 .57403 L
s
0 .60769 m
.00375 .60769 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.15608 .61178 m
.15608 .61803 L
s
.28836 .61178 m
.28836 .61803 L
s
.42063 .61178 m
.42063 .61803 L
s
.55291 .61178 m
.55291 .61803 L
s
.68519 .61178 m
.68519 .61803 L
s
.81746 .61178 m
.81746 .61803 L
s
.94974 .61178 m
.94974 .61803 L
s
.125 Mabswid
.05026 .61428 m
.05026 .61803 L
s
.07672 .61428 m
.07672 .61803 L
s
.10317 .61428 m
.10317 .61803 L
s
.12963 .61428 m
.12963 .61803 L
s
.18254 .61428 m
.18254 .61803 L
s
.20899 .61428 m
.20899 .61803 L
s
.23545 .61428 m
.23545 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.31481 .61428 m
.31481 .61803 L
s
.34127 .61428 m
.34127 .61803 L
s
.36772 .61428 m
.36772 .61803 L
s
.39418 .61428 m
.39418 .61803 L
s
.44709 .61428 m
.44709 .61803 L
s
.47354 .61428 m
.47354 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.52646 .61428 m
.52646 .61803 L
s
.57937 .61428 m
.57937 .61803 L
s
.60582 .61428 m
.60582 .61803 L
s
.63228 .61428 m
.63228 .61803 L
s
.65873 .61428 m
.65873 .61803 L
s
.71164 .61428 m
.71164 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.76455 .61428 m
.76455 .61803 L
s
.79101 .61428 m
.79101 .61803 L
s
.84392 .61428 m
.84392 .61803 L
s
.87037 .61428 m
.87037 .61803 L
s
.89683 .61428 m
.89683 .61803 L
s
.92328 .61428 m
.92328 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .00194 m
1 .00194 L
s
.99375 .08607 m
1 .08607 L
s
.99375 .1702 m
1 .1702 L
s
.99375 .25433 m
1 .25433 L
s
.99375 .33846 m
1 .33846 L
s
.99375 .4226 m
1 .4226 L
s
.99375 .50673 m
1 .50673 L
s
.99375 .59086 m
1 .59086 L
s
.125 Mabswid
.99625 .01876 m
1 .01876 L
s
.99625 .03559 m
1 .03559 L
s
.99625 .05241 m
1 .05241 L
s
.99625 .06924 m
1 .06924 L
s
.99625 .10289 m
1 .10289 L
s
.99625 .11972 m
1 .11972 L
s
.99625 .13655 m
1 .13655 L
s
.99625 .15337 m
1 .15337 L
s
.99625 .18703 m
1 .18703 L
s
.99625 .20385 m
1 .20385 L
s
.99625 .22068 m
1 .22068 L
s
.99625 .2375 m
1 .2375 L
s
.99625 .27116 m
1 .27116 L
s
.99625 .28798 m
1 .28798 L
s
.99625 .30481 m
1 .30481 L
s
.99625 .32164 m
1 .32164 L
s
.99625 .35529 m
1 .35529 L
s
.99625 .37212 m
1 .37212 L
s
.99625 .38894 m
1 .38894 L
s
.99625 .40577 m
1 .40577 L
s
.99625 .43942 m
1 .43942 L
s
.99625 .45625 m
1 .45625 L
s
.99625 .47307 m
1 .47307 L
s
.99625 .4899 m
1 .4899 L
s
.99625 .52355 m
1 .52355 L
s
.99625 .54038 m
1 .54038 L
s
.99625 .55721 m
1 .55721 L
s
.99625 .57403 m
1 .57403 L
s
.99625 .60769 m
1 .60769 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .15451 m
.06244 .15451 L
.10458 .15451 L
.14415 .15451 L
.18221 .15451 L
.22272 .15451 L
.26171 .15451 L
.30316 .15451 L
.34309 .15451 L
.3815 .15451 L
.42237 .15451 L
.46172 .15451 L
.49955 .15451 L
.53984 .15451 L
.57861 .15451 L
.61984 .15451 L
.65954 .15451 L
.69774 .15451 L
.73838 .15451 L
.77751 .15451 L
.81909 .15451 L
.85916 .15451 L
.89771 .15451 L
.93871 .15451 L
.97619 .15451 L
s
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.02381 .46353 m
.06244 .46353 L
.10458 .46353 L
.14415 .46353 L
.18221 .46353 L
.22272 .46353 L
.26171 .46353 L
.30316 .46353 L
.34309 .46353 L
.3815 .46353 L
.42237 .46353 L
.46172 .46353 L
.49955 .46353 L
.53984 .46353 L
.57861 .46353 L
.61984 .46353 L
.65954 .46353 L
.69774 .46353 L
.73838 .46353 L
.77751 .46353 L
.81909 .46353 L
.85916 .46353 L
.89771 .46353 L
.93871 .46353 L
.97619 .46353 L
s
.02381 .47398 m
.06244 .45979 L
.10458 .44434 L
.14415 .42984 L
.18221 .41591 L
.22272 .40109 L
.26171 .38684 L
.30316 .37172 L
.34309 .35715 L
.3815 .34316 L
.42237 .32828 L
.46172 .31397 L
.49955 .30022 L
.53984 .2856 L
.57861 .27153 L
.61984 .2566 L
.65954 .24222 L
.69774 .22841 L
.73838 .21372 L
.77751 .1996 L
.81909 .1846 L
.85916 .17016 L
.89771 .15629 L
.93871 .14154 L
.97619 .12808 L
s
.02381 .48022 m
.06244 .46611 L
.10458 .45073 L
.14415 .43631 L
.18221 .42244 L
.22272 .4077 L
.26171 .39352 L
.30316 .37847 L
.34309 .36398 L
.3815 .35005 L
.42237 .33525 L
.46172 .321 L
.49955 .30732 L
.53984 .29277 L
.57861 .27878 L
.61984 .26391 L
.65954 .24961 L
.69774 .23586 L
.73838 .22125 L
.77751 .20719 L
.81909 .19227 L
.85916 .1779 L
.89771 .16409 L
.93871 .14942 L
.97619 .13602 L
s
.02381 .48641 m
.06244 .47236 L
.10458 .45706 L
.14415 .44271 L
.18221 .42891 L
.22272 .41424 L
.26171 .40013 L
.30316 .38515 L
.34309 .37073 L
.3815 .35687 L
.42237 .34214 L
.46172 .32797 L
.49955 .31436 L
.53984 .29987 L
.57861 .28595 L
.61984 .27116 L
.65954 .25692 L
.69774 .24324 L
.73838 .2287 L
.77751 .21471 L
.81909 .19986 L
.85916 .18556 L
.89771 .17182 L
.93871 .15721 L
.97619 .14388 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`007oooool3
o`0000Cooooo0_l00004ooooo`;o00004_ooool3o`0000;ooooo1Ol00002ooooo`?o00004oooool3
o`0000?ooooo0ol00004ooooo`;o00004_ooool3o`0000Cooooo00?o0000ooooooooool00_ooool3
o`0001Cooooo00?o0000ooooooooool00oooool2o`0000Cooooo0_l0000Dooooo`04o`000?oooooo
ooooooooo`Go00000_ooool3o`0001?ooooo00?o0000ooooooooool00_ooool3o`0000Cooooo0_l0
000Dooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool3o`0000Oooooo000N
ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`00
0?ooooooooooo`00013ooooo00Go0000ooooooooooooooooo`000002ooooo`06o`000?oooooooooo
o`000?oooooo00000oooool00ol0003oooooooooo`0?ooooo`07o`000?ooooooooooooooool0003o
ooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01Ol0
003ooooooooooooooooo000000?ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`00
0?ooooooooooo`0001?ooooo00?o0000ooooooooool00_ooool01_l0003oooooooooool0003ooooo
o`0000?ooooo00?o0000ooooooooool04?ooool01Ol0003ooooooooooooooooo000000?ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00?ooooo
00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00Cooooo000Nooooo`05o`00
0?ooooooooooooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`00013ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool03oooool01Ol0003ooooooooooooooooo000000Gooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`0>ooooo`05o`000?ooooooooooooooool000001?ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo01;ooooo00Go0000ooooooooooooooooo`000002
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`04ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool001kooooo1?l0
0003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00004?ooool4o`0000Go
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0?ooooo`Co00001_ooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo00kooooo1?l00005ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool04_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Cooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`007_ooool00ol0003ooooooooo
o`04ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00004?ooool00ol0003o
ooooooooo`03ooooo`06o`000?ooooooooooooooool0003ooooo1?l0000Booooo`03o`000?oooooo
oooo00?ooooo1?l00003ooooo`04o`000?ooooooooooo`00013ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooo`000003o`0001Kooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool00002ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooool000000oooool00ol0003o
ooooo`000003o`0001Gooooo00?o0000ooooool000000ol00003ooooo`04o`000?ooooooooooo`00
01Gooooo00?o0000ooooooooool00oooool00ol0003oooooo`000003o`0000Oooooo000Oooooo`03
o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0000A
ooooo`03o`000?oooooooooo00;ooooo00Oo0000ooooooooooooooooo`000?oooooo000001Kooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`00017o
oooo00?o0000ooooooooool00_ooool01ol0003ooooooooooooooooo0000ooooool000005Oooool0
1Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool0000Aooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`03o`000?oooooo
000001Cooooo00Oo0000ooooooooooooooooo`000?oooooo000000Kooooo00Co0000oooooooooooo
00004Oooool01ol0003ooooooooooooooooo0000ooooool000000oooool00ol0003oooooo`00000:
ooooo`008?ooool2o`0000Cooooo0_l00004ooooo`;o00004oooool2o`0000?ooooo0ol00002oooo
o`Go00004oooool2o`0000;ooooo1Ol00003ooooo`;o00004oooool2o`0000;ooooo1Ol000000ooo
oooo0000o`000003o`00017ooooo1Ol00003ooooo`;o00001?ooool2o`0001;ooooo1Ol00002oooo
o`?o00000_ooool5o`00013ooooo1Ol000000ooooooo0000o`000003o`0000?ooooo0_l0000Boooo
o`Go000000?oooooo`000?l000000ol000000ooooooo0000o`000003o`0000Kooooo003oooooob7o
oooo003oooooob7ooooo000>ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`;o0000oooo
ool6ooooo`003Oooool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo0?oooooo0ooo
ool000gooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`02ooooooko00000Ooo
ool000gooooo00Co0000oooooooooooo00002?ooool4o`0000Cooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`03ooooo`7o00000Oooool000gooooo00Co0000oooooooooooo00001ooo
ool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0n_ooool1o`00007ooooo
000=ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03
o`000?oooooooooo0?[ooooo0Ol00001ooooo`003_ooool2o`0000Wooooo0ol00005ooooo`;o0000
n_ooool2o`00007ooooo000Qooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`008Oooool0
0ol0003oooooooooo`3jooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0n_ooool1o`00
007ooooo000Qooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`008Oooool2o`000?[ooooo
0_l00001ooooo`008Oooool00ol0003oooooooooo`3jooooo`7o00000Oooool0027ooooo00?o0000
ooooooooool0n_ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo0?[ooooo0Ol00001oooo
o`008Oooool2o`000?[ooooo0_l00001ooooo`008Oooool00ol0003oooooooooo`3jooooo`7o0000
0Oooool0027ooooo00?o0000ooooooooool0n_ooool1o`00007ooooo000Qooooo`03o`000?oooooo
oooo0?[ooooo0Ol00001ooooo`008Oooool2o`000?[ooooo0_l00001ooooo`008Oooool00ol0003o
ooooooooo`3jooooo`7o00000Oooool000;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo
0_l00005ooooo`;o00000oooool3o`0000Gooooo00?o0000ooooooooool0n_ooool1o`00007ooooo
00001Ooooooo0000oooooooooooo000000[ooooo00Go0000ooooooooooooooooo`000002ooooo`03
o`000?oooooo000000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3jooooo`7o
00000Oooool00005ooooool0003oooooooooool000002oooool01?l0003oooooooooool00002oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3joooo
o`7o00000Oooool00005ooooool0003oooooooooool000002?ooool4o`0000;ooooo00Co0000oooo
oooooooo00001Oooool00ol0003oooooooooo`02ooooo`;o0000n_ooool2o`00007ooooo00001Ooo
oooo0000oooooooooooo000000Oooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oo
ooooooooo`000?ooool01?l00005ooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`0000Go
ooooo`000?ooooooooooo`000007ooooo`05o`000?ooooooooooooooool000000_ooool01_l0003o
ooooooooool0003oooooo`0000Sooooo00?o0000ooooooooool0n_ooool1o`00007ooooo0002oooo
o`;o00002Oooool3o`0000Cooooo0_l00002ooooo`Go00001?ooool00ol0003oooooooooo`3joooo
o`7o00000Oooool0027ooooo0_l0003jooooo`;o00000Oooool0027ooooo00?o0000ooooooooool0
n_ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`008Oooool0
0ol0003oooooooooo`3jooooo`7o00000Oooool0027ooooo0_l0003jooooo`;o00000Oooool0027o
oooo00?o0000ooooooooool0n_ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo0??ooooo
0_l00005ooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0lOooool2o`0000Oooooo0Ol0
0001ooooo`008Oooool2o`000>oooooo0ol00002ooooo`;o00001?ooool2o`00007ooooo000Qoooo
o`03o`000?oooooooooo0>cooooo0_l00003ooooo`;o00001oooool1o`00007ooooo000Qooooo`03
o`000?oooooooooo0>Wooooo0ol00002ooooo`?o00000_ooool2o`0000Gooooo0Ol00001ooooo`00
8Oooool00ol0003oooooooooo`3Uooooo`Co00000oooool2o`0000?ooooo0_l00007ooooo`7o0000
0Oooool0027ooooo00?o0000ooooooooool0h_ooool3o`0000Cooooo0ol00002ooooo`?o00002Ooo
ool1o`00007ooooo000Qooooo`;o00001?ooooobo`0000Cooooo0_l00001ooooo`002?ooool2o`00
00Cooooo00?o0000ooooooooool00_ooool2o`0000Cooooo0ol00005ooooo`03o`000?oooooooooo
0=gooooo0_l00003ooooo`?o00001?ooool3o`0000kooooo0Ol00001ooooo`001oooool01?l0003o
ooooooooool0000:ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`3Jooooo`?o00000_ooool3o`0000?ooooo1?l0000Aooooo`7o00000Oooool000Oo
oooo00Co0000oooooooooooo00002oooool01Ol0003ooooooooooooooooo000000Kooooo00?o0000
ooooooooool0f?ooool2o`0000?ooooo0_l00003ooooo`?o00005Oooool1o`00007ooooo0007oooo
o`04o`000?ooooooooooo`0000Sooooo1?l00003ooooo`03o`000?oooooooooo00Cooooo0_l0003G
ooooo`;o00000_ooool3o`0000;ooooo0ol0000Gooooo`;o00000Oooool000Oooooo00Co0000oooo
oooooooo00001oooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`3Cooooo`?o00000_ooool2o`0000?ooooo0_l0000Kooooo`7o00000Ooo
ool000Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000;ooooo
0_l00006ooooo`03o`000?oooooooooo0=3ooooo0ol00002ooooo`?o00000_ooool3o`0001gooooo
0Ol00001ooooo`002?ooool2o`0000Wooooo0ol00004ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool0cOooool3o`000003ooooool0003o000000;o00000oooool2o`00023ooooo0Ol0
0001ooooo`008Oooool2o`000<_ooooo0ol000001?oooooo0000o`000?l00004ooooo`?o00008Ooo
ool2o`00007ooooo000Qooooo`03o`000?oooooooooo0<Oooooo0ol000001?oooooo0000o`000?l0
0003ooooo`Co00009Oooool1o`00007ooooo000Qooooo`03o`000?oooooooooo0<Cooooo0ol00000
1?oooooo0000o`000?l00003ooooo`?o0000:Oooool1o`00007ooooo000Qooooo`03o`000?oooooo
oooo0<7ooooo0ol00002ooooo`;o00000oooool3o`0002cooooo0Ol00001ooooo`008Oooool2o`00
0;oooooo0ol00002ooooo`?o00000_ooool3o`0002kooooo0_l00001ooooo`008Oooool00ol0003o
ooooooooo`2looooo`;o00000oooool2o`0000?ooooo0_l0000booooo`7o00000Oooool0027ooooo
00?o0000ooooooooool0^Oooool3o`0000;ooooo0ol00002ooooo`?o0000=?ooool1o`00007ooooo
000Qooooo`03o`000?oooooooooo0;Oooooo0_l00003ooooo`;o00000oooool2o`0003Oooooo0Ol0
0001ooooo`008Oooool00ol0003oooooooooo`2dooooo`?o00000_ooool3o`0000;ooooo0ol0000i
ooooo`7o00000Oooool0027ooooo0_l0002cooooo`;o00000oooool2o`0000?ooooo0_l0000koooo
o`;o00000Oooool0027ooooo00?o0000ooooooooool0[oooool3o`0000;ooooo0ol00002ooooo`?o
0000?_ooool1o`00007ooooo000Qooooo`03o`000?oooooooooo0:cooooo0ol00003ooooo`;o0000
0_ooool3o`00047ooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`2Yooooo`?o00000ooo
ool3o`000004ooooool0003o0000o`0004Cooooo0Ol00001ooooo`008Oooool2o`000:Oooooo0ol0
0003ooooo`?o000000Coooooo`000?l0003o0000A_ooool2o`00007ooooo000Qooooo`03o`000?oo
oooooooo0:?ooooo0ol00003ooooo`?o000000Coooooo`000?l0003o0000B_ooool1o`00007ooooo
0002ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`;o00001?ooool3o`0000?ooooo0ol0
0005ooooo`03o`000?oooooooooo0:3ooooo0ol00003ooooo`?o000000Coooooo`000?l0003o0000
COooool1o`00007ooooo00001Ooooooo0000oooooooooooo000000[ooooo00?o0000ooooooooool0
0_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`2Nooooo`;o00000oooool3o`0000;ooooo0_l0001@ooooo`7o00000Oooool00005oooo
ool0003oooooooooool000002oooool01Ol0003ooooooooooooooooo000000Oooooo00?o0000oooo
ooooool00_ooool2o`0009cooooo0ol00002ooooo`?o00000_ooool3o`00057ooooo0_l00001oooo
o`0000Goooooo`000?ooooooooooo`000008ooooo`Co00000oooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0VOooool2o`0000?ooooo0_l00003oooo
o`;o0000EOooool1o`00007ooooo00001Ooooooo0000oooooooooooo000000Oooooo00Go0000oooo
ooooooooooooo`000003ooooo`04o`000?ooooooooooooooo`Co00001Oooool00ol0003ooooooooo
o`2Fooooo`?o00000_ooool3o`0000;ooooo0ol0001Gooooo`7o00000Oooool00005ooooool0003o
ooooooooool000001oooool01Ol0003ooooooooooooooooo000000;ooooo0_l00003ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool0Toooool3o`0000;ooooo0ol00003ooooo`;o0000
F_ooool1o`00007ooooo0002ooooo`;o00002Oooool3o`0000Cooooo00Co0000oooooooooooooooo
1Ol00004ooooo`03o`000?oooooooooo093ooooo0ol000000ooooooo0000o`000002o`0000?ooooo
0ol0001Looooo`7o00000Oooool0027ooooo0_l0002?ooooo`;o000000Coooooo`000?l0003o0000
1?ooool3o`0005kooooo0_l00001ooooo`008Oooool00ol0003oooooooooo`2;ooooo`Ko00000ooo
ool4o`0006;ooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`28ooooo`?o000000?ooooo
o`000?l000000oooool3o`0006Kooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`25oooo
o`?o000000Coooooo`000?l0003o00000_ooool3o`0006Wooooo0Ol00001ooooo`008Oooool2o`00
08?ooooo0ol00002ooooo`;o00000oooool2o`0006_ooooo0_l00001ooooo`008Oooool00ol0003o
ooooooooo`1oooooo`?o00000oooool2o`0000;ooooo0ol0001^ooooo`7o00000Oooool0027ooooo
00?o0000ooooooooool0O?ooool3o`0000?ooooo0ol00002ooooo`;o0000LOooool1o`00007ooooo
000Qooooo`03o`000?oooooooooo07[ooooo0_l00003ooooo`?o00000_ooool3o`0007?ooooo0Ol0
0001ooooo`008Oooool2o`0007Sooooo0ol00002ooooo`?o000000?oooooo`000?l000000_l0001e
ooooo`;o00000Oooool0027ooooo00?o0000ooooooooool00oooooobo`0000Gooooo0Ol00001oooo
o`008Oooool00ol0003oooooooooo`1aooooo`?o00000oooool6o`0007gooooo0Ol00001ooooo`00
8Oooool00ol0003oooooooooo`1^ooooo`?o00000oooool3o`000003ooooool0003o0000083ooooo
0Ol00001ooooo`008Oooool2o`0006gooooo0_l00003ooooo`?o000000Coooooo`000?l0003o0000
POooool2o`00007ooooo000Qooooo`03o`000?oooooooooo06Wooooo0ol00002ooooo`?o00000_oo
ool2o`0008Gooooo0Ol00001ooooo`002?ooool2o`0000Cooooo00?o0000ooooooooool00_ooool2
o`0000?ooooo1Ol00004ooooo`03o`000?oooooooooo06Oooooo0_l00003ooooo`;o00000oooool2
o`0008Oooooo0Ol00001ooooo`001oooool01?l0003oooooooooool0000:ooooo`05o`000?oooooo
ooooooooool000000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo06Cooooo0ol0
0002ooooo`?o00000_ooool3o`0008Wooooo0Ol00001ooooo`001oooool01?l0003oooooooooool0
000;ooooo`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`1Qooooo`?o0000
0oooool2o`0000?ooooo0_l0002<ooooo`7o00000Oooool000Oooooo00Co0000oooooooooooo0000
2?ooool4o`0000Cooooo00?o0000ooooooooool00oooool2o`0005oooooo0ol00003ooooo`?o0000
0_ooool3o`0008gooooo0_l00001ooooo`001oooool01?l0003oooooooooool00007ooooo`07o`00
0?ooooooooooooooool0003oooooo`000003ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0G?ooool2o`0000?ooooo0ol00002ooooo`?o0000TOooool1o`00007ooooo0007ooooo`04
o`000?ooooooooooo`0000Oooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`1Iooooo`?o00000_ooool3o`000003ooooool0
003o000000;o0000U?ooool1o`00007ooooo0008ooooo`;o00002Oooool3o`0000?ooooo0ol00005
ooooo`03o`000?oooooooooo05Kooooo0ol00003ooooo`;o000000Coooooo`000?l0003o0000V?oo
ool1o`00007ooooo000Qooooo`;o0000E?ooool3o`0000?ooooo1_l0002Jooooo`;o00000Oooool0
027ooooo00?o0000ooooooooool0D?ooool3o`0000?ooooo0ol000000ooooooo0000o`00002Noooo
o`7o00000Oooool0027ooooo00?o0000ooooooooool0C_ooool2o`0000?ooooo0ol000001?oooooo
0000o`000?l0002Pooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0Boooool3o`0000;o
oooo0ol00002ooooo`;o0000Xoooool1o`00007ooooo000Qooooo`;o0000B_ooool2o`0000?ooooo
0_l00002ooooo`?o0000Y?ooool2o`00007ooooo000Qooooo`03o`000?oooooooooo04Kooooo0ol0
0002ooooo`?o000000Coooooo`000?l0003o0000Z?ooool1o`00007ooooo000Qooooo`03o`000?oo
oooooooo04?ooooo0ol00003ooooo`;o000000Coooooo`000?l0003o0000Zoooool1o`00007ooooo
000Qooooo`03o`000?oooooooooo043ooooo0ol00003ooooo`Ko0000[_ooool1o`00007ooooo000Q
ooooo`;o0000?_ooool3o`0000?ooooo1_l0002`ooooo`;o00000Oooool0027ooooo00?o0000oooo
ooooool0>_ooool3o`0000?ooooo1_l0002dooooo`7o00000Oooool0027ooooo00?o0000oooooooo
ool0=oooool3o`0000?ooooo1_l0002gooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0
=?ooool3o`0000?ooooo0ol000000ooooooo0000o`00002jooooo`7o00000Oooool0027ooooo00?o
0000ooooooooool0<Oooool3o`0000?ooooo0ol000001?oooooo0000o`000?l0002looooo`7o0000
0Oooool0027ooooo0_l0000`ooooo`;o00000oooool3o`0000;ooooo0_l0002nooooo`;o00000Ooo
ool000;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0_l00003ooooo`Go00000_ooool3
o`0000Gooooo00?o0000ooooooooool0;?ooool3o`0000;ooooo0ol00002ooooo`?o0000`Oooool1
o`00007ooooo00001Ooooooo0000oooooooooooo000000[ooooo00Go0000ooooooooooooooooo`00
0002ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`0Zooooo`;o00000oooool2o`0000?ooooo0_l00034ooooo`7o00000Oooool00005ooooool0003o
ooooooooool000002oooool01Ol0003ooooooooooooooooo000000Oooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`0Wooooo`?o00000_ooool3o`0000;ooooo0ol00036ooooo`7o0000
0Oooool00005ooooool0003oooooooooool000002?ooool4o`0000Cooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`02ooooo`;o00009_ooool2o`0000;ooooo0ol00003ooooo`;o0000
b?ooool2o`00007ooooo00001Ooooooo0000oooooooooooo000000Oooooo00Oo0000oooooooooooo
ooooo`000?oooooo000000?ooooo00?o0000ooooool000000ol00005ooooo`03o`000?oooooooooo
02;ooooo0ol000001?oooooo0000o`000?l00003ooooo`?o0000boooool1o`00007ooooo00001Ooo
oooo0000oooooooooooo000000Oooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo
00?o0000ooooool000002?ooool00ol0003oooooooooo`0Oooooo`?o000000Coooooo`000?l0003o
00000oooool3o`000<kooooo0Ol00001ooooo`000_ooool2o`0000Wooooo0ol00003ooooo`?o0000
0_ooool5o`0000Cooooo00?o0000ooooooooool07?ooool3o`000004ooooool0003o0000o`0000?o
oooo0ol0003Aooooo`7o00000Oooool0027ooooo0_l0000Jooooo`?o000000Coooooo`000?l0003o
00000oooool3o`000=?ooooo0_l00001ooooo`008Oooool00ol0003oooooooooo`0Fooooo`?o0000
0_ooool2o`0000?ooooo0ol0003Gooooo`7o00000Oooool0027ooooo00?o0000ooooooooool04ooo
ool3o`0000;ooooo0ol00002ooooo`?o0000f_ooool1o`00007ooooo000Qooooo`03o`000?oooooo
oooo017ooooo0_l00003ooooo`;o00000oooool2o`000=gooooo0Ol00001ooooo`008Oooool2o`00
00oooooo0ol00002ooooo`?o00000_ooool3o`000=kooooo0_l00001ooooo`008Oooool00ol0003o
ooooooooo`0<ooooo`;o00000oooool2o`0000?ooooo0_l0003Rooooo`7o00000Oooool0027ooooo
00?o0000ooooooooool00oooooobo`0000Gooooo0Ol00001ooooo`008Oooool00ol0003ooooooooo
o`07ooooo`;o00000oooool2o`0000?ooooo0_l0003Wooooo`7o00000Oooool0027ooooo00?o0000
ooooooooool01?ooool3o`0000;ooooo0ol00002ooooo`?o0000jOooool1o`00007ooooo000Qoooo
o`;o00001?ooool01?l0003oooooooooooooool2o`0000;ooooo0ol0003[ooooo`;o00000Oooool0
027ooooo00?o0000ooooooooool01?ooool3o`000004ooooool0003o0000o`000>oooooo0Ol00001
ooooo`008Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000000;o0000l_ooool1o`00
007ooooo000Qooooo`03o`000?oooooooooo00?ooooo0_l0003eooooo`7o00000Oooool0027ooooo
0_l0003jooooo`;o00000Oooool0027ooooo00?o0000ooooooooool0n_ooool1o`00007ooooo0008
ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`;o00001?ooool3o`0000Gooooo00?o0000
ooooooooool0n_ooool1o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000[ooooo00Co0000
oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?[ooooo0Ol0
0001ooooo`001oooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00_ooool2o`000?[ooooo0_l00001ooooo`001oooool01?l0003oooooooooool0
0008ooooo`Co00000oooool2o`0000Gooooo00?o0000ooooooooool0n_ooool1o`00007ooooo0007
ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000005ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0n_ooool1o`00007ooooo0007ooooo`04o`000?oo
ooooooooo`0000Oooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`3jooooo`7o00000Oooool000Sooooo0_l00009ooooo`?o
00000oooool3o`0000Gooooo00?o0000ooooooooool0n_ooool1o`00007ooooo000Qooooo`;o0000
n_ooool2o`00007ooooo000Qooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`008Oooool0
0ol0003oooooooooo`3jooooo`7o00000Oooool0027ooooo00?o0000ooooooooool0n_ooool1o`00
007ooooo000Qooooo`;o0000n_ooool2o`00007ooooo000Qooooo`03o`000?oooooooooo0?[ooooo
0Ol00001ooooo`008Oooool00ol0003oooooooooo`3jooooo`7o00000Oooool0027ooooo00?o0000
ooooooooool0n_ooool1o`00007ooooo000Qooooo`;o0000n_ooool2o`00007ooooo000Qooooo`03
o`000?oooooooooo0?[ooooo0Ol00001ooooo`008Oooool00ol0003oooooooooo`3jooooo`7o0000
0Oooool0027ooooo00?o0000ooooooooool0n_ooool1o`00007ooooo000Qooooo`;o0000n_ooool2
o`00007ooooo000Qooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`000_ooool2o`0000Co
oooo00?o0000ooooooooool00_ooool2o`0000Cooooo0ol00003ooooo`?o00001Oooool00ol0003o
ooooooooo`3jooooo`7o00000Oooool00005ooooool0003oooooooooool000002_ooool01?l0003o
ooooooooool00003ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`3jooooo`7o00000Oooool00005ooooool0003oooooooooool000002oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`3jooooo`7o00000Oooool00005ooooool0003oooooooooool000002?ooool4o`00
00?ooooo0_l00006ooooo`03o`000?oooooooooo00;ooooo0_l0003jooooo`;o00000Oooool00005
ooooool0003oooooooooool000001oooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000
ooooool000000ol00005ooooo`03o`000?oooooooooo0?[ooooo0Ol00001ooooo`0000Goooooo`00
0?ooooooooooo`000007ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`03o`00
0?oooooo000000Sooooo00?o0000ooooooooool0n_ooool1o`00007ooooo0002ooooo`;o00002Ooo
ool3o`0000?ooooo0ol00002ooooo`Go00001?ooool00ol0003oooooooooo`3jooooo`7o00000Ooo
ool0027ooooo0_l0003jooooo`;o00000Oooool0027ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0Nooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool07_ooool00ol0
003oooooooooo`0Oooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool07_ooool00ol0
003oooooooooo`0Oooooo`03o`000?oooooooooo00Wooooo0Ol00001ooooo`008Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00?ooooo0Ol00001ooooo`008Oooooono`00007ooooo
003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {570.786, 0.896099, 0.74497, \
0.000234254}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(pts = 
        Graphics[{PointSize[0.022], Point[{609, y2[609]}], 
            Point[{689, y2[689]}], Point[{770, y2[770]}]}];\)\)], "Input"],

Cell[BoxData[
    \(\(txt = 
        Graphics[{Text["\<h=5570\>", {655, 1.003  f}, {0, 1}], 
            Text["\<h=5630\>", {677, 1.008  f}, {1, 0}]}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[p1, pts, txt, 
      FrameTicks \[Rule] {{609, 689, 770}, None, 
          None, {{ .99  f, "\<0.99f\>"}, {f, "\<1.00f\>"}, {1.01  
                f, "\<1.01f\>"}}}, 
      FrameLabel \[Rule] {"\<Years BP\>", "\<Amount\n Present\>"}, 
      RotateLabel \[Rule] False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-3.15079 0.00529101 -15.1418 16.8264 [
[.07143 -0.0125 -9 -9 ]
[.07143 -0.0125 9 0 ]
[.49471 -0.0125 -9 -9 ]
[.49471 -0.0125 9 0 ]
[.92328 -0.0125 -9 -9 ]
[.92328 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -26 -21 ]
[.5 -0.0125 26 -9 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -52 -12.25 ]
[-0.01875 .30902 0 12.25 ]
[ 0 .61803 .125 0 ]
[1.0125 .15451 0 -6 ]
[1.0125 .15451 34 6 ]
[1.0125 .30902 0 -6 ]
[1.0125 .30902 34 6 ]
[1.0125 .46353 0 -6 ]
[1.0125 .46353 34 6 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07143 0 m
.07143 .00625 L
s
[(609)] .07143 -0.0125 0 1 Mshowa
.49471 0 m
.49471 .00625 L
s
[(689)] .49471 -0.0125 0 1 Mshowa
.92328 0 m
.92328 .00625 L
s
[(770)] .92328 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
gsave
.5 -0.0125 -87 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Years) show
99.000 13.000 moveto
(BP) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -113 -16.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 32.5 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Amount) show
69.000 25.500 moveto
(Present) show
111.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .61803 m
1 .61803 L
s
.99375 .15451 m
1 .15451 L
s
gsave
1.0125 .15451 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.99) show
87.000 13.000 moveto
(f) show
93.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .30902 m
1 .30902 L
s
gsave
1.0125 .30902 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.00) show
87.000 13.000 moveto
(f) show
93.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .46353 m
1 .46353 L
s
gsave
1.0125 .46353 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.01) show
87.000 13.000 moveto
(f) show
93.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .15451 m
.06244 .15451 L
.10458 .15451 L
.14415 .15451 L
.18221 .15451 L
.22272 .15451 L
.26171 .15451 L
.30316 .15451 L
.34309 .15451 L
.3815 .15451 L
.42237 .15451 L
.46172 .15451 L
.49955 .15451 L
.53984 .15451 L
.57861 .15451 L
.61984 .15451 L
.65954 .15451 L
.69774 .15451 L
.73838 .15451 L
.77751 .15451 L
.81909 .15451 L
.85916 .15451 L
.89771 .15451 L
.93871 .15451 L
.97619 .15451 L
s
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.02381 .46353 m
.06244 .46353 L
.10458 .46353 L
.14415 .46353 L
.18221 .46353 L
.22272 .46353 L
.26171 .46353 L
.30316 .46353 L
.34309 .46353 L
.3815 .46353 L
.42237 .46353 L
.46172 .46353 L
.49955 .46353 L
.53984 .46353 L
.57861 .46353 L
.61984 .46353 L
.65954 .46353 L
.69774 .46353 L
.73838 .46353 L
.77751 .46353 L
.81909 .46353 L
.85916 .46353 L
.89771 .46353 L
.93871 .46353 L
.97619 .46353 L
s
.02381 .47398 m
.06244 .45979 L
.10458 .44434 L
.14415 .42984 L
.18221 .41591 L
.22272 .40109 L
.26171 .38684 L
.30316 .37172 L
.34309 .35715 L
.3815 .34316 L
.42237 .32828 L
.46172 .31397 L
.49955 .30022 L
.53984 .2856 L
.57861 .27153 L
.61984 .2566 L
.65954 .24222 L
.69774 .22841 L
.73838 .21372 L
.77751 .1996 L
.81909 .1846 L
.85916 .17016 L
.89771 .15629 L
.93871 .14154 L
.97619 .12808 L
s
.02381 .48022 m
.06244 .46611 L
.10458 .45073 L
.14415 .43631 L
.18221 .42244 L
.22272 .4077 L
.26171 .39352 L
.30316 .37847 L
.34309 .36398 L
.3815 .35005 L
.42237 .33525 L
.46172 .321 L
.49955 .30732 L
.53984 .29277 L
.57861 .27878 L
.61984 .26391 L
.65954 .24961 L
.69774 .23586 L
.73838 .22125 L
.77751 .20719 L
.81909 .19227 L
.85916 .1779 L
.89771 .16409 L
.93871 .14942 L
.97619 .13602 L
s
.02381 .48641 m
.06244 .47236 L
.10458 .45706 L
.14415 .44271 L
.18221 .42891 L
.22272 .41424 L
.26171 .40013 L
.30316 .38515 L
.34309 .37073 L
.3815 .35687 L
.42237 .34214 L
.46172 .32797 L
.49955 .31436 L
.53984 .29987 L
.57861 .28595 L
.61984 .27116 L
.65954 .25692 L
.69774 .24324 L
.73838 .2287 L
.77751 .21471 L
.81909 .19986 L
.85916 .18556 L
.89771 .17182 L
.93871 .15721 L
.97619 .14388 L
s
.022 w
.07143 .46283 Mdot
.49471 .30907 Mdot
.92328 .15494 Mdot
gsave
.31481 .35537 -81 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
69.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5570) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.43122 .43262 -101 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
69.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5630) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{325.188, 201},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000550000bB000`400?l00000o`00003ooooooom6
ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6
ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6
ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6
ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6ooooo`00oooooom6
ooooo`00U?ooool3o`0000?ooooo0ol00003ooooo`Co000000Coooooo`000?l0003o00000oooool4
o`0000Sooooo1?l00002ooooo`?o0000QOooool009Gooooo00Go0000ooooooooooooooooo`000005
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0Q?ooool009Gooooo00Co
0000oooooooooooooooo1Ol00002ooooo`?o00000oooool00ol0003oooooooooo`03ooooo`?o0000
2Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo08Cooooo002Eooooo`05o`00
0?ooooooooooooooool000000oooool00ol0003oooooo`000002ooooo`04o`000?oooooooooooooo
o`;o00000oooool00ol0003oooooooooo`0:ooooo`?o00000oooool3o`0008Cooooo002Dooooo`03
o`000?oooooo000000?ooooo0ol00003ooooo`;o00000oooool2o`000003ooooool0003o000000;o
oooo1?l00008ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000Poooool0
09Cooooo00?o0000ooooool000008Oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0008?ooooo002Cooooo`;o000000?oooooo`000?l000007oooool4o`0000;ooooo1?l00024
ooooo`00oooooom6ooooo`00oooooom6ooooo`00@?ooool3o`0000Cooooo0_l00003ooooo`;o0000
E?ooool3o`0000?ooooo0ol00003ooooo`;o0000E_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00?ooooo0_l0000aooooo`00?oooool01Ol0003ooooooooooooooooo000000;ooooo
00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`1@ooooo`07o`000?oooooooooooooo
ool0003oooooo`000003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Doooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000<?oo
ool003oooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Gooooo
00?o0000ooooooooool0Coooool01ol0003ooooooooooooooooo0000ooooool000000oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo05?ooooo00?o0000ooooooooool00oooool01Ol0
003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0;_ooool003oooooo1?l00003oooo
o`04o`000?ooooooooooo`0000;ooooo1?l0001Aooooo`Co00000oooool3o`0000?ooooo1?l0001E
ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oo
oooooooo02kooooo000oooooo`03o`000?oooooooooo00Cooooo00Ko0000oooooooooooo0000oooo
ool00003ooooo`03o`000?oooooooooo04oooooo00?o0000ooooooooool00oooool01ol0003ooooo
oooooooooooo0000ooooool000000oooool00ol0003oooooooooo`1Dooooo`03o`000?oooooooooo
00?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0^ooooo`00@?ooool00ol0
003oooooooooo`03ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003ooooooooo
o`1@ooooo`03o`000?oooooooooo00;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?o
oooo00?o0000ooooooooool0D?ooool01ol0003ooooooooooooooooo0000ooooool000000oooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo02kooooo0011ooooo`;o00001?ooool2
o`0000?ooooo0ol0001Dooooo`;o00000oooool3o`0000?ooooo0ol0001Cooooo`Go000000?ooooo
o`000?l000000ol00003ooooo`;o0000<Oooool00?ooooooA_ooool00?ooooooA_ooool00?oooooo
A_ooool00?ooooooA_ooool003Soooooj?l0000Uooooo`00>?ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo05oooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool0Goooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool08oooool003Sooooo00?o0000ooooooooool0i?ooool00ol0003oooooooooo`0Sooooo`00>?oo
ool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooo
oooo0>Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0i?ooool00ol0
003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo02?o
oooo000hooooo`03o`000?oooooooooo0>Cooooo00?o0000ooooooooool08oooool003Sooooo00?o
0000ooooooooool0i?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3T
ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo00?o0000oooo
ooooool08oooool003Sooooo00?o0000ooooooooool0i?ooool00ol0003oooooooooo`0Sooooo`00
>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oo
oooooooo0>Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0i?ooool0
0ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo
02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo00?o0000ooooooooool08oooool003Sooooo
00?o0000ooooooooool0i?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooooooo
o`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo00?o0000
ooooooooool08oooool003Sooooo00?o0000ooooooooool0i?ooool00ol0003oooooooooo`0Soooo
o`00>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`00
0?oooooooooo0>Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0i?oo
ool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo00?o0000ooooooooool08oooool003So
oooo00?o0000ooooooooool0i?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooo
ooooo`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo00?o
0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0gOooool2o`0000Gooooo00?o0000
ooooooooool08oooool003Sooooo00?o0000ooooooooool0f_ooool5o`0000Gooooo00?o0000oooo
ooooool08oooool003Sooooo00?o0000ooooooooool0eoooool3o`000003ooooool0003o000000Oo
oooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0e?ooool3o`0000;ooooo
0_l00002ooooo`;o00001Oooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooooooo
o`3Aooooo`?o00000oooool2o`000004ooooool0003o0000o`0000Oooooo00?o0000ooooooooool0
1?ooool2o`0000Cooooo00?o0000ooooooooool00_ooool2o`0000Cooooo0_l00003ooooo`Go0000
1?ooool003Sooooo00?o0000ooooooooool0c_ooool<o`0000[ooooo00?o0000ooooooooool00ooo
ool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`04ooooo`00>?ooool00ol0003oooooooooo`02ooooomgo00000ooo
ool3o`0000Gooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`03ooooo`05o`00
0?ooooooooooooooool000001_ooool003Sooooo00?o0000ooooooooool0b?ooool3o`0000?ooooo
1ol0000?ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00002?ooool4o`0000;o
oooo1?l00003ooooo`03o`000?oooooooooo00Cooooo000hooooo`03o`000?oooooooooo0<Gooooo
0ol00003ooooo`?o00000_ooool4o`00013ooooo00?o0000ooooooooool00oooool01?l0003ooooo
ooooool00007ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`03o`000?oooooo
oooo00Co00001?ooool003Sooooo00?o0000ooooooooool0`_ooool3o`0000?ooooo0ol00002oooo
o`?o00005?ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000Oooooo00Oo0000
ooooooooooooooooo`000?oooooo000000?ooooo00Go0000ooooooooooooooooo`000006ooooo`00
>?ooool00ol0003oooooooooo`30ooooo`;o00000oooool3o`0000?ooooo0_l0000Gooooo`03o`00
0?oooooooooo00Cooooo0_l00009ooooo`?o00000oooool3o`0000Gooooo0_l00004ooooo`00>?oo
ool00ol0003oooooooooo`2mooooo`?o00000_ooool3o`0000?ooooo0ol0000Iooooo`03o`000?oo
oooooooo02?ooooo000hooooo`03o`000?oooooooooo0;_ooooo0_l00002ooooo`?o00000oooool3
o`0001cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0^?ooool3o`00
0004ooooool0003o0000o`0000?ooooo0ol0000Oooooo`03o`000?oooooooooo02?ooooo000hoooo
o`03o`000?oooooooooo0;Gooooo0ol000001?oooooo0000o`000?l00003ooooo`?o00008_ooool0
0ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`2booooo`?o000000Coooooo`00
0?l0003o00000oooool3o`0002Gooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooo
ooooool0[oooool3o`0000;ooooo0_l00003ooooo`?o0000:?ooool00ol0003oooooooooo`0Soooo
o`00>?ooool00ol0003oooooooooo`2/ooooo`?o00000_ooool3o`0000;ooooo0ol0000[ooooo`03
o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0:Wooooo0ol00003ooooo`;o0000
0oooool2o`0002kooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0Y_oo
ool3o`0000?ooooo0ol00002ooooo`?o0000<?ooool00ol0003oooooooooo`0Sooooo`00>?ooool0
0ol0003oooooooooo`2Tooooo`;o00000oooool3o`0000?ooooo0_l0000cooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo0:7ooooo0ol00002ooooo`?o00000oooool3o`00
03Gooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0Woooool2o`0000?o
oooo0_l00003ooooo`?o0000>?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooo
ooooo`2Mooooo`;o00000_ooool3o`0000;ooooo0ol0000kooooo`03o`000?oooooooooo02?ooooo
000hooooo`03o`000?oooooooooo09[ooooo0ol00002ooooo`;o00000_ooool3o`0003kooooo00?o
0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0Uoooool3o`0000?ooooo0_l00000
1?oooooo0000o`000?l00011ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooo
oooo09Cooooo0ol00003ooooo`Ko0000A?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0
003oooooooooo`2Aooooo`?o00000oooool6o`0004Oooooo00?o0000ooooooooool08oooool003So
oooo00?o0000ooooooooool0S_ooool3o`0000?ooooo1_l0001:ooooo`03o`000?oooooooooo02?o
oooo000hooooo`03o`000?oooooooooo08_ooooo0ol00003ooooo`Ko0000COooool00ol0003ooooo
ooooo`0Sooooo`00>?ooool00ol0003oooooooooo`28ooooo`?o00000oooool3o`000003ooooool0
003o0000053ooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0Q_ooool2
o`0000;ooooo1?l000001?oooooo0000o`000?l0001Booooo`03o`000?oooooooooo02?ooooo000h
ooooo`03o`000?oooooooooo08?ooooo0ol000001?oooooo0000o`000?l00003ooooo`;o0000EOoo
ool00ol0003oooooooooo`0Sooooo`002?ooool3o`0000?ooooo0ol00004ooooo`?o00000_ooool4
o`0000?ooooo0ol00002ooooo`?o000000?oooooo`000?l000000_ooool2o`0000Sooooo00?o0000
ooooooooool0POooool2o`000004ooooool0003o0000o`0000?ooooo0ol0001Gooooo`03o`000?oo
oooooooo02?ooooo0009ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooo000000Kooooo00Co0000oooooooooooo00000_oo
ool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo07kooooo1_l00003ooooo`?o0000
F_ooool00ol0003oooooooooo`0Sooooo`002Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00;ooooo1Ol00002ooooo`?o00000_ooool5o`0000;ooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo07_ooooo0ol000000ooooooo0000
o`000003ooooo`?o0000GOooool00ol0003oooooooooo`0Sooooo`002Oooool3o`0000?ooooo0_l0
0003ooooo`07o`000?ooooooooooooooool0003oooooo`000005ooooo`05o`000?oooooooooooooo
ool000000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool0N?ooool3o`0000;ooooo0_l00002ooooo`?o0000H?ooool00ol0003oooooooooo`0S
ooooo`002Oooool01Ol0003oooooooooool0003ooooo00;o000000?oooooo`000?l000000_ooool3
o`0000?ooooo1?l00002ooooo`?o00000_ooool4o`0000;ooooo1?l00008ooooo`03o`000?oooooo
oooo07Gooooo0ol00003ooooo`;o000000Coooooo`000?l0003o0000Hoooool00ol0003ooooooooo
o`0Sooooo`002Oooool01?l0003oooooooooool0000Pooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool0L_ooool3o`0000?ooooo1_l0001Vooooo`03o`000?oooooooooo02?ooooo0008
ooooo`Co00008Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo06kooooo1?l00003
ooooo`?o000000?oooooo`000?l00000JOooool00ol0003oooooooooo`03ooooo`?o00001?ooool0
0ol0003oooooooooo`03ooooo`;o00001?ooool2o`0000;ooooo1Ol00004ooooo`00>?ooool00ol0
003oooooooooo`1]ooooo`So000000Coooooo`000?l0003o0000Joooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00003ooooo`03o`000?oooooooooo00Cooooo000hooooo`03o`000?oooooooooo00;ooooogOl0
0003ooooo`?o00001_ooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo
00Co0000oooooooooooo00000oooool00ol0003oooooooooo`04ooooo`00>?ooool00ol0003ooooo
ooooo`1Xooooo`;o00000_ooool8o`00073ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0
003oooooooooo`04ooooo`00>?ooool00ol0003oooooooooo`1Vooooo`;o000000Coooooo`000?l0
003o00000_ooool3o`0007?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool4o`0000Cooooo000h
ooooo`03o`000?oooooooooo03Cooooo1_l000000ooooooo0000o`000002o`0000;ooooo0ol00003
ooooo`?o00001?ooool00ol0003oooooooooo`03ooooo`;o00003Oooool6o`0000?ooooo0ol0001e
ooooo`03o`000?oooooooooo00?ooooo0_l0000:ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00000oooool00ol0003oooooooooo`04ooooo`00>?ooool00ol0003ooooooooo
o`0eooooo`04o`000?ooooooooooo`0000Oooooo00Oo0000ooooooooooooooooo`000?oooooo0000
00?ooooo00Go0000ooooooooooooooooo`000004ooooo`04o`000?ooooooooooo`0000Wooooo0ol0
00000ooooooo0000o`000003ooooo`?o0000N?ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Wooooo0_l00004ooooo`;o00001Oooool2o`0000Cooooo0002ooooo`;o000000?ooooo
o`000?l000000_l000001?oooooo0000ooooool00002ooooo`?o00001?ooool2o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_ooool2o`0001Cooooo00?o0000ooooooooool0=Ooo
ool01?l0003oooooooooool00002ooooo`Co00001Oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Co
oooo0ol000001?oooooo0000o`000?l00002ooooo`?o0000Noooool00ol0003oooooooooo`0Soooo
o`000_ooool03Ol0003ooooooooooooooooo0000ooooool0003oooooo`000?oooooo0000ooooool0
00000oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo03Gooooo00Co
0000oooooooooooo00002oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo
00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooooooo`?o00000_ooool2o`00
00;ooooo0ol0001nooooo`03o`000?oooooooooo02?ooooo0002ooooo`Go000000Soooooo`000?oo
oooo0000ooooool0003oooooo`0000?ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool00002ooooo`04o`000?ooooooooooo`0001Kooooo00?o0000ooooooooool0=Oooool3o`00
00Sooooo1?l00002ooooo`Co00001_ooool01?l0003oooooooooool00002ooooo`Co00000oooool2
o`000004ooooool0003o0000o`00087ooooo00?o0000ooooooooool08oooool000?ooooo00?o0000
ooooool000000_ooool01ol0003oooooo`000?oooooo0000ooooool000000oooool01?l0003ooooo
ooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00005_ooool0
0ol0003oooooooooo`0eooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool4o`0000?ooooo1_l0
0024ooooo`03o`000?oooooooooo02?ooooo0003ooooo`03o`000?oooooo000000;ooooo0_l00000
0ooooooo0000ooooo`02ooooo`?o00000_ooool2o`000004ooooool0003o0000ooooo`Co00000_oo
ool4o`0001Cooooo00?o0000ooooooooool0=?ooool2o`0000[ooooo1Ol000000ooooooo0000o`00
0003o`000003ooooool0003o000000?o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0004o`0008Oooooo00?o0000ooooooooool08oooool000Cooooo00?o0000ooooooooool06_ooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooooooo04oooooo0ol00002ooooo`Ko0000R_ooool0
0ol0003oooooooooo`0Sooooo`000oooool2o`0001cooooo00?o0000ooooooooool05?ooool00ol0
003oooooooooo`1=ooooo`;o00000_ooool6o`0008gooooo00?o0000ooooooooool08oooool003So
oooo00?o0000ooooooooool0Boooool2o`000005ooooool0003o0000o`000?ooool00_l0002@oooo
o`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo04Sooooo1_l000001?oooooo
0000o`000?l0002Booooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo04Go
oooo1_l00002ooooo`;o0000UOooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooo
ooooo`11ooooo`Oo00000oooool2o`0009Oooooo00?o0000ooooooooool08oooool003Sooooo00?o
0000ooooooooool0?_ooool3o`000004ooooool0003o0000o`0000?ooooo0ol0002Iooooo`03o`00
0?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo03_ooooo0ol000001?oooooo0000o`00
0?l00003ooooo`?o0000W?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooooooo
o`0hooooo`?o00000_ooool2o`0000;ooooo1?l0002Oooooo`03o`000?oooooooooo02?ooooo000h
ooooo`03o`000?oooooooooo03Kooooo0_l00002ooooo`?o000000Coooooo`000?l0003o0000Xooo
ool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0cooooo`?o00000_ooool2
o`000004ooooool0003o0000o`000:Kooooo00?o0000ooooooooool08oooool003Sooooo00?o0000
ooooooooool0<Oooool2o`0000;ooooo1_l0002Yooooo`03o`000?oooooooooo02?ooooo000hoooo
o`03o`000?oooooooooo02oooooo0_l000001Ooooooo0000o`000?l0003ooooo00;o0000[?ooool0
0ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0/ooooo`Ko000000Coooooo`00
0?l0003o0000[_ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Yoooo
o`?o000000?oooooo`000?l000000_ooool2o`000;7ooooo00?o0000ooooooooool08oooool003So
oooo00?o0000ooooooooool09_ooool3o`000004ooooool0003o0000o`0000;ooooo0_l0002coooo
o`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo02?ooooo0ol00002ooooo`;o
00000_ooool3o`000;Gooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0
8?ooool3o`0000?ooooo0_l000001?oooooo0000o`000?l0000>ooooo`Ko000000?oooooo`000?l0
00000_l00002ooooo`?o00000oooool3o`0000?ooooo0ol00004ooooo`;o0000R?ooool00ol0003o
ooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Mooooo`?o00000oooool6o`0001;ooooo
00Co0000oooooooooooo00001oooool01ol0003ooooooooooooooooo0000ooooool000000oooool0
0ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0QOoo
ool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Kooooo`;o00000oooool6
o`0001Gooooo00Co0000oooooooooooo00000_ooool4o`0000Gooooo00?o0000ooooool000000ooo
ool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
QOooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`0Hooooo`?o00000_oo
ool6o`0001Sooooo00Co0000oooooooooooo00002oooool00ol0003oooooo`000003o`0000Cooooo
0_l00003ooooo`04o`000?ooooooooooo`0008Oooooo00?o0000ooooooooool08oooool003Sooooo
00?o0000ooooooooool05_ooool2o`0000;ooooo1_l0000Kooooo`?o00002?ooool4o`0000;ooooo
00?o0000ooooooooool01oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo08Go
oooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool04oooool3o`000005oooo
ool0003o0000o`000?ooool00_l0000Nooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000000_ooool01?l0
003oooooooooool00027ooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo
013ooooo0ol000001Ooooooo0000o`000?l0003ooooo00?o00007oooool2o`0000[ooooo1Ol00003
ooooo`;o00000oooool3o`0000Cooooo0_l00028ooooo`03o`000?oooooooooo02?ooooo000hoooo
o`03o`000?oooooooooo00cooooo1?l000001?oooooo0000o`000?l00002ooooo`;o0000c?ooool0
0ol0003oooooooooo`03ooooo`?o00001?ooool00ol0003oooooooooo`03ooooo`;o00000oooool3
o`0000;ooooo1Ol00004ooooo`00>?ooool00ol0003oooooooooo`0:ooooo`Oo00000_ooool3o`00
0<kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08ooooo`04o`000?oooooooooo
o`0000?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04ooooo`00>?ooool00ol0
003oooooooooo`02ooooomgo00000oooool3o`0000Kooooo00?o0000ooooooooool02?ooool01?l0
003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool0
03Sooooo00?o0000ooooooooool01Oooool3o`0000;ooooo1_l0003Dooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool02?ooool01?l0003oooooooooool00003ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool01?ooool003Sooooo00?o0000ooooooooool00oooool2o`00
00;ooooo2?l0003Eooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool01?l0
003oooooooooool00003ooooo`03o`000?oooooooooo00;ooooo1?l00004ooooo`00>?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooo000000Go0000f_ooool00ol0003oooooooooo`03oooo
o`;o00002_ooool01?l0003oooooooooool00002ooooo`;o00001Oooool00ol0003oooooooooo`04
ooooo`00>?ooool00ol0003oooooooooo`02ooooo`Go0000gOooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Wooooo0_l00004ooooo`03o`000?oooooooooo00Cooooo0_l00004oooo
o`00>?ooool00ol0003oooooooooo`02ooooo`;o0000h?ooool00ol0003oooooooooo`0Sooooo`00
>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oo
oooooooo0>Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0i?ooool0
0ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo
02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo00?o0000ooooooooool08oooool003Sooooo
00?o0000ooooooooool0i?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooooooo
o`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo00?o0000
ooooooooool08oooool003Sooooo00?o0000ooooooooool0i?ooool00ol0003oooooooooo`0Soooo
o`00>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`00
0?oooooooooo0>Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0i?oo
ool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooo
oooo02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo00?o0000ooooooooool08oooool003So
oooo00?o0000ooooooooool0i?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003ooooo
ooooo`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo00?o
0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0i?ooool00ol0003oooooooooo`0S
ooooo`00>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03
o`000?oooooooooo0>Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0
i?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oo
oooooooo02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo00?o0000ooooooooool08oooool0
03Sooooo00?o0000ooooooooool0i?ooool00ol0003oooooooooo`0Sooooo`00>?ooool00ol0003o
ooooooooo`3Tooooo`03o`000?oooooooooo02?ooooo000hooooo`03o`000?oooooooooo0>Cooooo
00?o0000ooooooooool08oooool003Sooooo00?o0000ooooooooool0i?ooool00ol0003ooooooooo
o`0Sooooo`00>?ooool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo02?ooooo000hoooo
o`03o`000?oooooooooo0>Cooooo00?o0000ooooooooool08oooool003Sooooo00?o0000oooooooo
ool0i?ooool00ol0003oooooooooo`0Sooooo`00>?oooooXo`0002Gooooo003oooooodKooooo003o
ooooodKooooo003oooooodKooooo003oooooodKooooo003oooooodKooooo003oooooodKooooo003o
ooooodKooooo003oooooodKooooo003oooooodKooooo003oooooodKooooo003oooooodKooooo003o
ooooodKooooo003oooooodKooooo003oooooodKooooo003oooooodKooooo003oooooodKooooo0000
\
\>"],
  ImageRangeCache->{{{0, 324.188}, {200, 0}} -> {549.403, 0.889444, 0.818297, \
0.000257311}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowSize->{520, 624},
WindowMargins->{{20, Automatic}, {Automatic, 44}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 50, 0, 56, "Section"],

Cell[CellGroupData[{
Cell[1851, 57, 47, 0, 46, "Subsection"],

Cell[CellGroupData[{
Cell[1923, 61, 47, 1, 27, "Input"],
Cell[1973, 64, 45, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2055, 70, 66, 1, 27, "Input"],
Cell[2124, 73, 52, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2213, 79, 66, 1, 27, "Input"],
Cell[2282, 82, 52, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2371, 88, 66, 1, 27, "Input"],
Cell[2440, 91, 52, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2529, 97, 231, 4, 59, "Input"],
Cell[2763, 103, 14501, 356, 186, 3182, 212, "GraphicsData", "PostScript", \
"Graphics"],
Cell[17267, 461, 130, 3, 27, "Output"]
}, Closed]],
Cell[17412, 467, 188, 4, 75, "Input"],
Cell[17603, 473, 229, 4, 91, "Input"],

Cell[CellGroupData[{
Cell[17857, 481, 314, 6, 107, "Input"],
Cell[18174, 489, 38529, 976, 214, 15611, 689, "GraphicsData", "PostScript", \
"Graphics"],
Cell[56706, 1467, 130, 3, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[56885, 1476, 46, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[56956, 1480, 43, 1, 27, "Input"],
Cell[57002, 1483, 41, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[57080, 1489, 66, 1, 27, "Input"],
Cell[57149, 1492, 52, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[57238, 1498, 66, 1, 27, "Input"],
Cell[57307, 1501, 52, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[57396, 1507, 66, 1, 27, "Input"],
Cell[57465, 1510, 52, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[57554, 1516, 231, 4, 59, "Input"],
Cell[57788, 1522, 27851, 833, 186, 7449, 577, "GraphicsData", "PostScript", \
"Graphics"],
Cell[85642, 2357, 130, 3, 27, "Output"]
}, Closed]],
Cell[85787, 2363, 169, 3, 75, "Input"],
Cell[85959, 2368, 169, 3, 75, "Input"],

Cell[CellGroupData[{
Cell[86153, 2375, 309, 6, 107, "Input"],
Cell[86465, 2383, 38419, 934, 229, 13924, 627, "GraphicsData", "PostScript", \
"Graphics"],
Cell[124887, 3319, 130, 3, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[125066, 3328, 37, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[125128, 3332, 44, 1, 27, "Input"],
Cell[125175, 3335, 42, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[125254, 3341, 66, 1, 27, "Input"],
Cell[125323, 3344, 52, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[125412, 3350, 66, 1, 27, "Input"],
Cell[125481, 3353, 52, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[125570, 3359, 66, 1, 27, "Input"],
Cell[125639, 3362, 52, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[125728, 3368, 204, 4, 59, "Input"],
Cell[125935, 3374, 31772, 997, 186, 9042, 712, "GraphicsData", "PostScript", \
"Graphics"],
Cell[157710, 4373, 130, 3, 27, "Output"]
}, Closed]],
Cell[157855, 4379, 163, 3, 59, "Input"],
Cell[158021, 4384, 166, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[158212, 4391, 306, 6, 107, "Input"],
Cell[158521, 4399, 35379, 897, 209, 13915, 627, "GraphicsData", "PostScript", \
"Graphics"],
Cell[193903, 5298, 130, 3, 27, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

